/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.utils;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.classmate.util.ResolvedTypeCache;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationGenericsException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public final class HussarIntegrationGenericsUtils {
    private static volatile GenericsUtilsBean BEAN = null;

    private HussarIntegrationGenericsUtils() {
    }

    public static Type[] resolveSuperTypeArguments(Class<?> superClass, Class<?> childClass, Type ... childArguments) {
        return HussarIntegrationGenericsUtils.getUtilsBean().resolveSuperTypeArguments(superClass, childClass, childArguments);
    }

    public static Type resolveFieldType(Field field, Class<?> clazz, Type ... arguments) {
        return HussarIntegrationGenericsUtils.getUtilsBean().resolveFieldType(field, clazz, arguments);
    }

    public static Type resolveGetterType(Method getter, Class<?> clazz, Type ... arguments) {
        return HussarIntegrationGenericsUtils.getUtilsBean().resolveGetterType(getter, clazz, arguments);
    }

    public static Type resolveSetterType(Method setter, Class<?> clazz, Type ... arguments) {
        return HussarIntegrationGenericsUtils.getUtilsBean().resolveSetterType(setter, clazz, arguments);
    }

    public static GenericsUtilsBean createUtilsBean() {
        return new GenericsUtilsBean();
    }

    public static GenericsUtilsBean createUtilsBean(boolean concurrentTypeCache, int typeCacheLimit) {
        return new GenericsUtilsBean(concurrentTypeCache, typeCacheLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GenericsUtilsBean getUtilsBean() {
        if (BEAN != null) return BEAN;
        Class<HussarIntegrationGenericsUtils> clazz = HussarIntegrationGenericsUtils.class;
        synchronized (HussarIntegrationGenericsUtils.class) {
            if (BEAN != null) return BEAN;
            BEAN = HussarIntegrationGenericsUtils.createUtilsBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return BEAN;
        }
    }

    public static interface LazyType
    extends Type {
        public Type resolve();

        public static boolean isLazy(Type type) {
            if (type == null) {
                throw new NullPointerException();
            }
            if (type instanceof LazyType) {
                return true;
            }
            if (type instanceof Class) {
                return false;
            }
            if (type instanceof TypeVariable) {
                return false;
            }
            if (type instanceof ParameterizedType) {
                Type[] arguments;
                Type owner = ((ParameterizedType)type).getOwnerType();
                if (owner != null && LazyType.isLazy(owner)) {
                    return true;
                }
                for (Type argument : arguments = ((ParameterizedType)type).getActualTypeArguments()) {
                    if (!LazyType.isLazy(argument)) continue;
                    return true;
                }
                return false;
            }
            if (type instanceof GenericArrayType) {
                Type elementType = ((GenericArrayType)type).getGenericComponentType();
                return LazyType.isLazy(elementType);
            }
            if (type instanceof WildcardType) {
                for (Type upperBound : ((WildcardType)type).getUpperBounds()) {
                    if (!LazyType.isLazy(upperBound)) continue;
                    return true;
                }
                for (Type lowerBound : ((WildcardType)type).getLowerBounds()) {
                    if (!LazyType.isLazy(lowerBound)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    public static final class GenericsUtilsBean {
        public static final int DEFAULT_TYPE_CACHE_LIMIT = 256;
        private final TypeResolver typeResolver;
        private final MemberResolver memberResolver;

        public GenericsUtilsBean() {
            this(false, 256);
        }

        public GenericsUtilsBean(boolean concurrentTypeCache, int typeCacheLimit) {
            if (typeCacheLimit < 0) {
                typeCacheLimit = 256;
            }
            ResolvedTypeCache typeCache = concurrentTypeCache ? ResolvedTypeCache.concurrentCache((int)typeCacheLimit) : ResolvedTypeCache.lruCache((int)typeCacheLimit);
            this.typeResolver = new TypeResolver(typeCache);
            this.memberResolver = new MemberResolver(this.typeResolver);
        }

        public Type[] resolveSuperTypeArguments(Class<?> superClass, Class<?> childClass, Type ... childArguments) {
            if (superClass == null || childClass == null) {
                throw new NullPointerException();
            }
            if (!superClass.isAssignableFrom(childClass)) {
                throw new IllegalArgumentException();
            }
            ResolvedType resolvedChildType = this.typeResolver.resolve(childClass, childArguments != null ? childArguments : new Type[]{});
            ResolvedType resolvedParentType = resolvedChildType.findSupertype(superClass);
            List parentArguments = resolvedParentType.getTypeParameters();
            return (Type[])parentArguments.stream().map(GenericsUtilsBean::toJavaType).toArray(Type[]::new);
        }

        public Type resolveFieldType(Field field, Class<?> clazz, Type ... arguments) {
            if (field == null || clazz == null) {
                throw new NullPointerException();
            }
            if (Modifier.isStatic(field.getModifiers()) || !field.getDeclaringClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException();
            }
            ResolvedType resolvedClass = this.typeResolver.resolve(clazz, arguments != null ? arguments : new Type[]{});
            ResolvedTypeWithMembers resolvedClassWithMembers = this.memberResolver.resolve(resolvedClass, null, null);
            ResolvedField resolvedField = null;
            for (ResolvedField memberField : resolvedClassWithMembers.getMemberFields()) {
                if (!Objects.equals(field, memberField.getRawMember())) continue;
                resolvedField = memberField;
                break;
            }
            if (resolvedField == null) {
                throw new HussarIntegrationGenericsException("field '" + field + "' not resolved in class '" + clazz + "'");
            }
            return GenericsUtilsBean.toJavaType(resolvedField.getType());
        }

        public Type resolveGetterType(Method getter, Class<?> clazz, Type ... arguments) {
            if (getter == null || clazz == null) {
                throw new NullPointerException();
            }
            if (Modifier.isStatic(getter.getModifiers()) || getter.getParameterCount() != 0 || Objects.equals(getter.getReturnType(), Void.TYPE)) {
                throw new IllegalArgumentException();
            }
            ResolvedMethod resolvedGetter = this.resolveMethod(getter, clazz, arguments);
            return GenericsUtilsBean.toJavaType(resolvedGetter.getReturnType());
        }

        public Type resolveSetterType(Method setter, Class<?> clazz, Type ... arguments) {
            if (setter == null || clazz == null) {
                throw new NullPointerException();
            }
            if (Modifier.isStatic(setter.getModifiers()) || setter.getParameterCount() != 1 || !Objects.equals(setter.getReturnType(), Void.TYPE)) {
                throw new IllegalArgumentException();
            }
            ResolvedMethod resolvedSetter = this.resolveMethod(setter, clazz, arguments);
            return GenericsUtilsBean.toJavaType(resolvedSetter.getArgumentType(0));
        }

        private ResolvedMethod resolveMethod(Method method, Class<?> clazz, Type ... arguments) {
            if (method == null || clazz == null) {
                throw new NullPointerException();
            }
            if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException();
            }
            ResolvedType resolvedClass = this.typeResolver.resolve(clazz, arguments != null ? arguments : new Type[]{});
            ResolvedTypeWithMembers resolvedClassWithMembers = this.memberResolver.resolve(resolvedClass, null, null);
            ResolvedMethod resolvedMethod = null;
            for (ResolvedMethod memberMethod : resolvedClassWithMembers.getMemberMethods()) {
                if (!Objects.equals(method, memberMethod.getRawMember())) continue;
                resolvedMethod = memberMethod;
                break;
            }
            if (resolvedMethod == null) {
                throw new HussarIntegrationGenericsException("method '" + resolvedMethod + "' not resolved in class '" + clazz + "'");
            }
            return resolvedMethod;
        }

        private static Type toJavaType(ResolvedType resolvedType) {
            if (resolvedType == null) {
                throw new NullPointerException();
            }
            if (resolvedType.isPrimitive()) {
                return resolvedType.getErasedType();
            }
            if (resolvedType.isArray()) {
                int level = 1;
                ResolvedType elementType = resolvedType.getArrayElementType();
                while (elementType.isArray()) {
                    elementType = elementType.getArrayElementType();
                    ++level;
                }
                return GenericsUtilsBean.toJavaArrayType(elementType, level);
            }
            if (resolvedType.getSelfReferencedType() != null) {
                return new LazyReferenceType(resolvedType);
            }
            Class raw = resolvedType.getErasedType();
            List arguments = resolvedType.getTypeParameters();
            if (CollectionUtils.isEmpty((Collection)arguments)) {
                return raw;
            }
            return TypeUtils.parameterize((Class)raw, (Type[])((Type[])arguments.stream().map(GenericsUtilsBean::toJavaType).toArray(Type[]::new)));
        }

        private static Type toJavaArrayType(ResolvedType elementType, int level) {
            if (elementType == null) {
                throw new NullPointerException();
            }
            if (elementType.isPrimitive()) {
                Class raw = elementType.getErasedType();
                if (raw == Void.TYPE) {
                    throw new IllegalArgumentException();
                }
                return GenericsUtilsBean.toRawArrayType(raw, level);
            }
            if (elementType.isArray()) {
                while (elementType.isArray()) {
                    elementType = elementType.getArrayElementType();
                    ++level;
                }
                return GenericsUtilsBean.toJavaArrayType(elementType, level);
            }
            if (elementType.getSelfReferencedType() != null) {
                return new LazyArrayType(elementType, level);
            }
            Class raw = elementType.getErasedType();
            List arguments = elementType.getTypeParameters();
            if (CollectionUtils.isEmpty((Collection)arguments)) {
                return GenericsUtilsBean.toRawArrayType(raw, level);
            }
            ParameterizedType parameterizeElementType = TypeUtils.parameterize((Class)raw, (Type[])((Type[])arguments.stream().map(GenericsUtilsBean::toJavaType).toArray(Type[]::new)));
            return GenericsUtilsBean.toGenericArrayType(parameterizeElementType, level);
        }

        private static Class<?> toRawArrayType(Class<?> elementType, int level) {
            Class<?> clazz = elementType;
            for (int i = 0; i < level; ++i) {
                clazz = Array.newInstance(clazz, 0).getClass();
            }
            return clazz;
        }

        private static Type toGenericArrayType(Type elementType, int level) {
            Type type = elementType;
            for (int i = 0; i < level; ++i) {
                type = TypeUtils.genericArrayType((Type)type);
            }
            return type;
        }

        private static final class LazyArrayType
        implements LazyType {
            private final int level;
            private final ResolvedType elementType;

            public LazyArrayType(ResolvedType elementType, int level) {
                if (elementType == null) {
                    throw new NullPointerException();
                }
                if (level < 1) {
                    throw new IllegalArgumentException();
                }
                if (elementType.getSelfReferencedType() == null) {
                    throw new IllegalArgumentException();
                }
                this.level = level;
                this.elementType = elementType;
            }

            @Override
            public Type resolve() {
                ResolvedType recursiveElementType = this.elementType.getSelfReferencedType();
                return GenericsUtilsBean.toJavaArrayType(recursiveElementType, this.level);
            }

            @Override
            public String getTypeName() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.elementType);
                for (int i = 0; i < this.level; ++i) {
                    builder.append("[]");
                }
                return builder.toString();
            }
        }

        private static final class LazyReferenceType
        implements LazyType {
            private final ResolvedType recursiveType;

            public LazyReferenceType(ResolvedType recursiveType) {
                if (recursiveType == null) {
                    throw new NullPointerException();
                }
                if (recursiveType.getSelfReferencedType() == null) {
                    throw new IllegalArgumentException();
                }
                this.recursiveType = recursiveType;
            }

            @Override
            public Type resolve() {
                return GenericsUtilsBean.toJavaType(this.recursiveType.getSelfReferencedType());
            }

            @Override
            public String getTypeName() {
                return this.recursiveType.getTypeName();
            }
        }
    }
}

