/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.utils;

import com.jxdinfo.hussar.integration.support.annotation.EntityProperty;
import com.jxdinfo.hussar.integration.support.annotation.magic.AliasFor;
import com.jxdinfo.hussar.integration.support.annotation.magic.CompositeOf;
import com.jxdinfo.hussar.integration.support.annotation.magic.Extends;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationEntityException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.objenesis.ObjenesisHelper;
import org.springframework.util.ConcurrentReferenceHashMap;

public final class HussarIntegrationEntityUtils {
    private static final Logger logger = LoggerFactory.getLogger(HussarIntegrationEntityUtils.class);
    private static volatile EntityUtilsBean BEAN = null;

    private HussarIntegrationEntityUtils() {
    }

    public static boolean isProbablyEntity(Class<?> clazz) {
        return HussarIntegrationEntityUtils.getUtilsBean().isProbablyEntity(clazz);
    }

    public static boolean isProbablyConstructableEntity(Class<?> clazz) {
        return HussarIntegrationEntityUtils.getUtilsBean().isProbablyConstructableEntity(clazz);
    }

    public static <T> T createEntity(Class<T> clazz) {
        return HussarIntegrationEntityUtils.getUtilsBean().createEntity(clazz);
    }

    public static boolean hasProperty(Object object, String property) {
        return HussarIntegrationEntityUtils.getUtilsBean().hasProperty(object, property);
    }

    public static Object getProperty(Object object, String property, boolean explicit) {
        return HussarIntegrationEntityUtils.getUtilsBean().getProperty(object, property, explicit);
    }

    public static void setProperty(Object object, String property, Object value, boolean explicit) {
        HussarIntegrationEntityUtils.getUtilsBean().setProperty(object, property, value, explicit);
    }

    public static void copyProperties(Object target, Object source) {
        HussarIntegrationEntityUtils.getUtilsBean().copyProperties(target, source);
    }

    public static Map<String, EntityPropertyDescriptor> getProperties(Class<?> clazz) {
        return HussarIntegrationEntityUtils.getUtilsBean().getProperties(clazz);
    }

    public static EntityPropertyDescriptor getPropertyDescriptor(Class<?> clazz, String property) {
        return HussarIntegrationEntityUtils.getUtilsBean().getPropertyDescriptor(clazz, property);
    }

    public static Map<String, EntityPropertyDescriptor> getReadableProperties(Class<?> clazz) {
        return HussarIntegrationEntityUtils.getUtilsBean().getReadableProperties(clazz);
    }

    public static Map<String, EntityPropertyDescriptor> getWritableProperties(Class<?> clazz) {
        return HussarIntegrationEntityUtils.getUtilsBean().getWritableProperties(clazz);
    }

    public static EntityUtilsBean createUtilsBean() {
        return new EntityUtilsBean();
    }

    public static EntityUtilsBean createUtilsBean(boolean oneshot) {
        return new EntityUtilsBean(oneshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EntityUtilsBean getUtilsBean() {
        if (BEAN != null) return BEAN;
        Class<HussarIntegrationEntityUtils> clazz = HussarIntegrationEntityUtils.class;
        synchronized (HussarIntegrationEntityUtils.class) {
            if (BEAN != null) return BEAN;
            BEAN = HussarIntegrationEntityUtils.createUtilsBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return BEAN;
        }
    }

    private static boolean isIgnorableSpecialField(Field field) {
        String name = field.getName();
        if ("metaClass".equals(name)) {
            return HussarIntegrationEntityUtils.isGroovyMetaClassField(field);
        }
        return false;
    }

    private static boolean isIgnorableSpecialGetter(Method method) {
        String name;
        switch (name = method.getName()) {
            case "getClass": {
                return HussarIntegrationEntityUtils.isJavaObjectGetClass(method);
            }
            case "getCallbacks": {
                return HussarIntegrationEntityUtils.isCglibGetCallbacks(method);
            }
            case "getMetaClass": {
                return HussarIntegrationEntityUtils.isGroovyMetaClassGetter(method);
            }
        }
        return false;
    }

    private static boolean isIgnorableSpecialSetter(Method method) {
        String name = method.getName();
        if ("setMetaClass".equals(name)) {
            return HussarIntegrationEntityUtils.isGroovyMetaClassSetter(method);
        }
        return false;
    }

    private static boolean isJavaObjectGetClass(Method method) {
        Class<?> returnType = method.getReturnType();
        return Objects.equals(returnType, Class.class) && method.getParameterCount() == 0;
    }

    private static boolean isCglibGetCallbacks(Method method) {
        Class<?> itemType;
        String pkgName;
        Class<?> returnType = method.getReturnType();
        if (returnType.isArray() && (pkgName = HussarIntegrationEntityUtils.getPackageName(itemType = returnType.getComponentType())) != null && pkgName.contains(".cglib")) {
            return pkgName.startsWith("net.sf.cglib") || pkgName.startsWith("org.hibernate.repackage.cglib") || pkgName.startsWith("org.springframework.cglib");
        }
        return false;
    }

    private static boolean isGroovyMetaClassField(Field field) {
        Class<?> fieldType = field.getType();
        return StringUtils.startsWith((CharSequence)HussarIntegrationEntityUtils.getPackageName(fieldType), (CharSequence)"groovy.lang");
    }

    private static boolean isGroovyMetaClassGetter(Method method) {
        if (method.getParameterCount() == 0) {
            Class<?> returnType = method.getReturnType();
            return StringUtils.startsWith((CharSequence)HussarIntegrationEntityUtils.getPackageName(returnType), (CharSequence)"groovy.lang");
        }
        return false;
    }

    private static boolean isGroovyMetaClassSetter(Method method) {
        if (Objects.equals(method.getReturnType(), Void.TYPE) && method.getParameterCount() == 1) {
            Class<?> argumentType = method.getParameterTypes()[0];
            return StringUtils.startsWith((CharSequence)HussarIntegrationEntityUtils.getPackageName(argumentType), (CharSequence)"groovy.lang");
        }
        return false;
    }

    private static String getPackageName(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        return pkg != null ? pkg.getName() : null;
    }

    public static class AnnotationMagician {
        private final Map<Object, Optional<Object>> cache;

        public AnnotationMagician() {
            this(new ConcurrentHashMap<Object, Optional<Object>>());
        }

        public AnnotationMagician(Map<Object, Optional<Object>> cache) {
            this.cache = cache;
        }

        public <A extends Annotation> A getAnnotation(AnnotatedElement annotatedElement, Class<A> annotationClass) {
            return AnnotationMagician.assertZeroOrOne(this.getAnnotations(annotatedElement, annotationClass), annotatedElement);
        }

        public <A extends Annotation> List<A> getAnnotations(AnnotatedElement annotatedElement, Class<A> annotationClass) {
            return this.getCached(Arrays.asList(1, annotatedElement, annotationClass), () -> this.getAnnotations(annotatedElement.getAnnotations(), annotationClass));
        }

        public boolean instanceOf(Annotation annotation, Class<? extends Annotation> targetAnnotationClass) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            return this.getCached(Arrays.asList(2, annotationType), () -> AnnotationMagician.getAnnotationHierarchy(annotationType)).contains(targetAnnotationClass);
        }

        public <A extends Annotation> A cast(Annotation annotation, Class<A> targetAnnotationClass) {
            Annotation ret = this.getCached(Arrays.asList(3, annotation, targetAnnotationClass), () -> AnnotationMagician.examineAnnotation(annotation, targetAnnotationClass));
            if (ret == null) {
                throw new ClassCastException("Can't cast " + annotation + " to class " + targetAnnotationClass + "!");
            }
            return (A)ret;
        }

        public boolean isAnnotationPresent(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
            return !this.getAnnotations(targetClass, annotationClass).isEmpty();
        }

        public boolean isAnnotationPresent(Method targetMethod, Class<? extends Annotation> annotationClass) {
            return !this.getAnnotations(targetMethod, annotationClass).isEmpty();
        }

        private <T> T getCached(List<Object> keys, Supplier<T> supplier) {
            Optional<Object> ret = this.cache.get(keys);
            if (ret == null) {
                ret = Optional.ofNullable(supplier.get());
                this.cache.put(keys, ret);
            }
            return ret.orElse(null);
        }

        private <A extends Annotation> List<A> getAnnotations(Annotation[] annotations, Class<A> targetClass) {
            return Stream.of(annotations).flatMap(this::expandAnnotation).map(annotation -> AnnotationMagician.examineAnnotation(annotation, targetClass)).filter(Objects::nonNull).collect(Collectors.toList());
        }

        private int indexOf(Annotation[] annotations, Class<? extends Annotation> targetAnnotation) {
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i].annotationType() != targetAnnotation) continue;
                return i;
            }
            return -1;
        }

        private Stream<Annotation> expandAnnotation(Annotation annotation) {
            Annotation[] annotationsOnTargetAnnotationType = annotation.annotationType().getAnnotations();
            int compositeOfIndex = this.indexOf(annotationsOnTargetAnnotationType, CompositeOf.class);
            int extendsIndex = this.indexOf(annotationsOnTargetAnnotationType, Extends.class);
            if (compositeOfIndex == -1) {
                return Stream.of(annotation);
            }
            LinkedList result = Stream.of(((CompositeOf)annotationsOnTargetAnnotationType[compositeOfIndex]).value()).map(klass -> (Annotation)Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, new InvocationHandler((Class)klass, annotation){
                Map cache = new HashMap();
                final /* synthetic */ Class val$klass;
                final /* synthetic */ Annotation val$annotation;
                {
                    this.val$klass = clazz;
                    this.val$annotation = annotation;
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("annotationType".equals(method.getName())) {
                        return this.val$klass;
                    }
                    if ("toString".equals(method.getName())) {
                        return "@" + this.val$klass.toString();
                    }
                    Object result = this.cache.get(method.getName());
                    if (result != null) {
                        return result;
                    }
                    for (Method methodInCompositeAnnotation : this.val$annotation.annotationType().getMethods()) {
                        AliasFor aliasFor = methodInCompositeAnnotation.getAnnotation(AliasFor.class);
                        if (aliasFor == null || !this.isDirectAlias(aliasFor, method) && !this.isIndirectAlias(aliasFor, method)) continue;
                        result = methodInCompositeAnnotation.invoke((Object)this.val$annotation, new Object[0]);
                        this.cache.put(method.getName(), result);
                        return result;
                    }
                    try {
                        Object ret = this.val$klass.getMethod(method.getName(), new Class[0]).getDefaultValue();
                        if (ret == null) {
                            throw new IllegalStateException("Can't invoke " + this.val$klass.getName() + "." + method.getName() + "() on composite annotation " + this.val$annotation);
                        }
                        return ret;
                    }
                    catch (NoSuchMethodError e) {
                        throw new IllegalStateException("Can't invoke " + this.val$klass.getName() + "." + method.getName() + "() on composite annotation " + this.val$annotation, e);
                    }
                }

                private boolean isIndirectAlias(AliasFor aliasFor, Method methodBeingInvoked) {
                    if (aliasFor.target() != this.val$klass) {
                        return false;
                    }
                    AliasFor redirect = methodBeingInvoked.getAnnotation(AliasFor.class);
                    return redirect != null && redirect.target() == AliasFor.DefaultThis.class && redirect.value().equals(aliasFor.value());
                }

                private boolean isDirectAlias(AliasFor aliasFor, Method methodBeingInvoked) {
                    return aliasFor.target() == this.val$klass && aliasFor.value().equals(methodBeingInvoked.getName());
                }
            })).collect(Collectors.toCollection(LinkedList::new));
            if (extendsIndex != -1) {
                if (extendsIndex < compositeOfIndex) {
                    result.addFirst(annotation);
                } else {
                    result.add(annotation);
                }
            }
            return result.stream();
        }

        private static LinkedHashSet<Class<? extends Annotation>> getAnnotationHierarchy(Class<? extends Annotation> klass) {
            Class<? extends Annotation> currentClass = klass;
            LinkedHashSet<Class<? extends Annotation>> hierarchy = new LinkedHashSet<Class<? extends Annotation>>();
            while (currentClass != null) {
                if (!hierarchy.add(currentClass)) {
                    throw new IllegalArgumentException("Annotation hierarchy circular inheritance detected: " + currentClass);
                }
                currentClass = AnnotationMagician.getSuperAnnotationOrNull(currentClass);
            }
            return hierarchy;
        }

        private static <A extends Annotation> A assertZeroOrOne(List<A> annotations, Object target) {
            if (annotations.size() > 1) {
                throw new IllegalArgumentException("Found more than one annotation on " + target + ":\n" + annotations.stream().map(Annotation::toString).collect(Collectors.joining("\n")));
            }
            return (A)(annotations.isEmpty() ? null : (Annotation)annotations.get(0));
        }

        private static <A extends Annotation> A examineAnnotation(Annotation actual, Class<A> targetAnnotationClass) {
            LinkedHashSet<Class<? extends Annotation>> hierarchy = AnnotationMagician.getAnnotationHierarchy((actual = AnnotationMagician.getActualAnnotationBehindProxy(actual)).annotationType());
            if (!hierarchy.contains(targetAnnotationClass)) {
                return null;
            }
            return (A)((Annotation)Proxy.newProxyInstance(targetAnnotationClass.getClassLoader(), new Class[]{targetAnnotationClass, AnnotationAdapter.class}, new AnnotationAdapterProxy<A>(actual, targetAnnotationClass, hierarchy)));
        }

        private static Annotation getActualAnnotationBehindProxy(Annotation annotation) {
            if (annotation instanceof AnnotationAdapter) {
                return ((AnnotationAdapter)((Object)annotation)).getActualAnnotation();
            }
            return annotation;
        }

        private static Optional<Object> searchInHierarchy(Annotation actual, Class<? extends Annotation> targetAnnotationClass, LinkedHashSet<Class<? extends Annotation>> hierarchy, String name) {
            try {
                Method method = actual.annotationType().getMethod(name, new Class[0]);
                return Optional.of(AnnotationMagician.safeInvokeAnnotationMethod(method, actual));
            }
            catch (NoSuchMethodException e) {
                for (Method method : actual.annotationType().getMethods()) {
                    AliasFor aliasFor = method.getAnnotation(AliasFor.class);
                    if (aliasFor == null || aliasFor.target() != AliasFor.DefaultThis.class && aliasFor.target() != targetAnnotationClass || !name.equals(aliasFor.value())) continue;
                    return Optional.of(AnnotationMagician.safeInvokeAnnotationMethod(method, actual));
                }
                block7: for (Class clazz : hierarchy) {
                    Annotation[] annotationsOnCurrentAnnotationClass;
                    for (Annotation annotationOnCurrentAnnotationClass : annotationsOnCurrentAnnotationClass = clazz.getAnnotations()) {
                        if (!hierarchy.contains(annotationOnCurrentAnnotationClass.annotationType())) continue;
                        try {
                            Method method = annotationOnCurrentAnnotationClass.annotationType().getMethod(name, new Class[0]);
                            return Optional.of(AnnotationMagician.safeInvokeAnnotationMethod(method, annotationOnCurrentAnnotationClass));
                        }
                        catch (NoSuchMethodException ignored) {
                            continue block7;
                        }
                    }
                }
                try {
                    Method method = targetAnnotationClass.getMethod(name, new Class[0]);
                    return Optional.of(method.getDefaultValue());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static Object safeInvokeAnnotationMethod(Method method, Annotation annotation) {
            try {
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static Class<? extends Annotation> getSuperAnnotationOrNull(Class<? extends Annotation> currentClass) {
            Extends extendsAnnotation = currentClass.getAnnotation(Extends.class);
            return extendsAnnotation == null ? null : extendsAnnotation.value();
        }

        private static class AnnotationAdapterProxy<A extends Annotation>
        implements InvocationHandler {
            private final Annotation actual;
            private final Class<A> targetAnnotationClass;
            private final LinkedHashSet<Class<? extends Annotation>> actualAnnotationHierarchy;
            private Map<String, Optional<Object>> methodsCache = new ConcurrentHashMap<String, Optional<Object>>();

            AnnotationAdapterProxy(Annotation actual, Class<A> targetAnnotationClass, LinkedHashSet<Class<? extends Annotation>> actualAnnotationHierarchy) {
                this.actual = actual;
                this.targetAnnotationClass = targetAnnotationClass;
                this.actualAnnotationHierarchy = actualAnnotationHierarchy;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == AnnotationAdapter.class) {
                    return this.actual;
                }
                if ("hashCode".equals(method.getName())) {
                    return AnnotationMagician.getActualAnnotationBehindProxy(this.actual).hashCode();
                }
                if ("equals".equals(method.getName()) && method.getParameters().length == 1) {
                    if (args[0] instanceof Annotation) {
                        return this.actual.equals(AnnotationMagician.getActualAnnotationBehindProxy((Annotation)args[0]));
                    }
                    return this.actual.equals(args[0]);
                }
                Optional cachedField = this.methodsCache.get(method.getName());
                if (cachedField == null) {
                    cachedField = AnnotationMagician.searchInHierarchy(this.actual, this.targetAnnotationClass, this.actualAnnotationHierarchy, method.getName());
                    this.methodsCache.put(method.getName(), cachedField);
                }
                return cachedField.orElse(null);
            }
        }

        static interface AnnotationAdapter {
            public Annotation getActualAnnotation();
        }
    }

    public static final class EntityPropertyAccessor
    implements EntityMemberAccessor {
        private final String name;
        private final boolean setter;
        private final Class<?> rawType;
        private final Type genericType;
        private final Method accessor;

        public EntityPropertyAccessor(String name, boolean setter, Class<?> rawType, Type genericType, Method accessor) {
            if (name == null || rawType == null || accessor == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.setter = setter;
            this.rawType = rawType;
            this.genericType = genericType;
            this.accessor = accessor;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isReadable() {
            return !this.setter;
        }

        @Override
        public boolean isWritable() {
            return this.setter;
        }

        @Override
        public Class<?> getRawType() {
            return this.rawType;
        }

        @Override
        public Type getGenericType() {
            return this.genericType;
        }

        public Method getAccessor() {
            return this.accessor;
        }

        @Override
        public Object read(Object instance) {
            this.accessor.setAccessible(true);
            try {
                return this.accessor.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new HussarIntegrationEntityException("cannot read property '" + this.name + "' of class " + instance.getClass(), ex);
            }
            catch (InvocationTargetException ex) {
                throw new HussarIntegrationEntityException("cannot read property '" + this.name + "' of class " + instance.getClass(), ex.getTargetException());
            }
        }

        @Override
        public void write(Object instance, Object value) {
            this.accessor.setAccessible(true);
            try {
                this.accessor.invoke(instance, value);
            }
            catch (IllegalAccessException ex) {
                throw new HussarIntegrationEntityException("cannot write property '" + this.name + "' of class " + instance.getClass(), ex);
            }
            catch (InvocationTargetException ex) {
                throw new HussarIntegrationEntityException("cannot write property '" + this.name + "' of class " + instance.getClass(), ex.getTargetException());
            }
        }

        public String toString() {
            return "EntityPropertyAccessor{name='" + this.name + '\'' + ", accessor=" + this.accessor + '}';
        }
    }

    public static final class EntityFieldAccessor
    implements EntityMemberAccessor {
        private final String name;
        private final boolean writable;
        private final Class<?> rawType;
        private final Type genericType;
        private final Field accessor;

        public EntityFieldAccessor(String name, boolean writable, Class<?> rawType, Type genericType, Field accessor) {
            if (name == null || rawType == null || accessor == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.writable = writable;
            this.rawType = rawType;
            this.genericType = genericType;
            this.accessor = accessor;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return this.writable;
        }

        @Override
        public Class<?> getRawType() {
            return this.rawType;
        }

        @Override
        public Type getGenericType() {
            return this.genericType;
        }

        public Field getAccessor() {
            return this.accessor;
        }

        @Override
        public Object read(Object instance) {
            this.accessor.setAccessible(true);
            try {
                return this.accessor.get(instance);
            }
            catch (IllegalAccessException ex) {
                throw new HussarIntegrationEntityException("cannot read property '" + this.name + "' of class " + instance.getClass(), ex);
            }
        }

        @Override
        public void write(Object instance, Object value) {
            this.accessor.setAccessible(true);
            try {
                this.accessor.set(instance, value);
            }
            catch (IllegalAccessException ex) {
                throw new HussarIntegrationEntityException("cannot write property '" + this.name + "' of class " + instance.getClass(), ex);
            }
        }

        public String toString() {
            return "EntityFieldAccessor{name='" + this.name + '\'' + ", accessor=" + this.accessor + '}';
        }
    }

    public static interface EntityMemberAccessor {
        public String getName();

        public boolean isReadable();

        public boolean isWritable();

        public Class<?> getRawType();

        public Type getGenericType();

        public Object read(Object var1);

        public void write(Object var1, Object var2);
    }

    public static final class EntityPropertyDescriptor {
        private final String name;
        private final EntityFieldAccessor field;
        private final EntityPropertyAccessor getter;
        private final EntityPropertyAccessor setter;

        private EntityPropertyDescriptor(String name, EntityFieldAccessor field, EntityPropertyAccessor getter, EntityPropertyAccessor setter) {
            this.name = name;
            this.field = field;
            this.getter = getter;
            this.setter = setter;
        }

        public static EntityPropertyDescriptor of(String name, EntityFieldAccessor field) {
            if (name == null || field == null) {
                throw new NullPointerException();
            }
            return new EntityPropertyDescriptor(name, field, null, null);
        }

        public static EntityPropertyDescriptor of(String name, EntityPropertyAccessor getter, EntityPropertyAccessor setter) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (getter == null && setter == null) {
                throw new IllegalArgumentException();
            }
            return new EntityPropertyDescriptor(name, null, getter, setter);
        }

        public static EntityPropertyDescriptor of(String name, EntityFieldAccessor field, EntityPropertyAccessor getter, EntityPropertyAccessor setter) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (field == null && getter == null && setter == null) {
                throw new IllegalArgumentException();
            }
            return new EntityPropertyDescriptor(name, field, getter, setter);
        }

        public String getName() {
            return this.name;
        }

        public EntityFieldAccessor getField() {
            return this.field;
        }

        public EntityPropertyAccessor getGetter() {
            return this.getter;
        }

        public EntityPropertyAccessor getSetter() {
            return this.setter;
        }

        public boolean isReadable() {
            return this.getter != null || this.field != null;
        }

        public boolean isWritable() {
            return this.setter != null || this.field != null && this.field.isWritable();
        }

        public EntityMemberAccessor getReadAccessor() {
            if (this.getter != null) {
                return this.getter;
            }
            return this.field;
        }

        public EntityMemberAccessor getWriteAccessor() {
            if (this.setter != null) {
                return this.setter;
            }
            if (this.field != null && this.field.isWritable()) {
                return this.field;
            }
            return null;
        }
    }

    private static final class IntrospectData {
        private final Class<?> target;
        private final Map<String, EntityPropertyDescriptor> properties;

        public IntrospectData(Class<?> target, Map<String, EntityPropertyDescriptor> properties) {
            if (target == null || properties == null) {
                throw new NullPointerException();
            }
            this.target = target;
            this.properties = Collections.unmodifiableMap(properties);
        }

        public Class<?> getTarget() {
            return this.target;
        }

        public Map<String, EntityPropertyDescriptor> getProperties() {
            return this.properties;
        }
    }

    private static enum TypeJudgementKind {
        ABSOLUTELY_NOT_ENTITY(false, false),
        PROBABLY_CONSTRUCTABLE_ENTITY(true, true),
        PROBABLY_NON_CONSTRUCTABLE_ENTITY(true, false);

        private final boolean entity;
        private final boolean constructable;

        private TypeJudgementKind(boolean entity, boolean constructable) {
            this.entity = entity;
            this.constructable = constructable;
        }

        public boolean isProbablyEntity() {
            return this.entity;
        }

        public boolean isProbablyConstructableEntity() {
            return this.constructable;
        }
    }

    public static final class EntityUtilsBean {
        private static final int DEFAULT_JUDGEMENT_CACHE_CAPACITY = 16;
        private static final int DEFAULT_INTROSPECT_CACHE_CAPACITY = 16;
        private final boolean oneshot;
        private volatile Reference<PropertyUtilsBean> propertyUtils = null;
        private volatile Reference<AnnotationMagician> annotationMagician = null;
        private final Map<Class<?>, TypeJudgementKind> judgementCache;
        private final Map<Class<?>, IntrospectData> introspectCache;

        public EntityUtilsBean() {
            this(false);
        }

        public EntityUtilsBean(boolean oneshot) {
            this.oneshot = oneshot;
            this.judgementCache = new ConcurrentReferenceHashMap(16, oneshot ? ConcurrentReferenceHashMap.ReferenceType.WEAK : ConcurrentReferenceHashMap.ReferenceType.SOFT);
            this.introspectCache = new ConcurrentReferenceHashMap(16, oneshot ? ConcurrentReferenceHashMap.ReferenceType.WEAK : ConcurrentReferenceHashMap.ReferenceType.SOFT);
        }

        public boolean isProbablyEntity(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            TypeJudgementKind judgement = this.getEntityTypeJudgement(clazz);
            return judgement.isProbablyEntity();
        }

        public boolean isProbablyConstructableEntity(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            TypeJudgementKind judgement = this.getEntityTypeJudgement(clazz);
            return judgement.isProbablyConstructableEntity();
        }

        private TypeJudgementKind getEntityTypeJudgement(Class<?> clazz) {
            return this.judgementCache.computeIfAbsent(clazz, this::judgeEntityType);
        }

        private TypeJudgementKind judgeEntityType(Class<?> clazz) {
            boolean hasDefaultConstructor;
            boolean iterator;
            boolean container;
            if (clazz.isPrimitive() || clazz.isArray() || clazz.isEnum() || clazz.isAnnotation()) {
                return TypeJudgementKind.ABSOLUTELY_NOT_ENTITY;
            }
            boolean number = Number.class.isAssignableFrom(clazz);
            if (number) {
                return TypeJudgementKind.ABSOLUTELY_NOT_ENTITY;
            }
            boolean bl = container = Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
            if (container) {
                return TypeJudgementKind.ABSOLUTELY_NOT_ENTITY;
            }
            boolean bl2 = iterator = Iterator.class.isAssignableFrom(clazz) || Spliterator.class.isAssignableFrom(clazz) || PrimitiveIterator.class.isAssignableFrom(clazz);
            if (iterator) {
                return TypeJudgementKind.ABSOLUTELY_NOT_ENTITY;
            }
            boolean stream = BaseStream.class.isAssignableFrom(clazz);
            if (stream) {
                return TypeJudgementKind.ABSOLUTELY_NOT_ENTITY;
            }
            boolean throwable = Throwable.class.isAssignableFrom(clazz);
            if (throwable) {
                return TypeJudgementKind.ABSOLUTELY_NOT_ENTITY;
            }
            boolean type = Type.class.isAssignableFrom(clazz);
            if (type) {
                return TypeJudgementKind.ABSOLUTELY_NOT_ENTITY;
            }
            boolean blacklisted = StringUtils.startsWithAny((CharSequence)clazz.getName(), (CharSequence[])new CharSequence[]{"java.lang.", "java.util.", "java.math.", "java.time.", "java.sql.", "java.text.", "java.net.", "java.io.", "java.nio."});
            if (blacklisted) {
                return TypeJudgementKind.ABSOLUTELY_NOT_ENTITY;
            }
            int modifiers = clazz.getModifiers();
            if (clazz.isInterface() || Modifier.isAbstract(modifiers)) {
                return TypeJudgementKind.PROBABLY_NON_CONSTRUCTABLE_ENTITY;
            }
            if (clazz.isMemberClass() && !Modifier.isStatic(modifiers)) {
                return TypeJudgementKind.PROBABLY_NON_CONSTRUCTABLE_ENTITY;
            }
            if (clazz.isAnonymousClass() || clazz.isLocalClass()) {
                return TypeJudgementKind.PROBABLY_NON_CONSTRUCTABLE_ENTITY;
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                hasDefaultConstructor = Modifier.isPublic(constructor.getModifiers());
            }
            catch (NoSuchMethodException ignore) {
                hasDefaultConstructor = false;
            }
            return hasDefaultConstructor ? TypeJudgementKind.PROBABLY_CONSTRUCTABLE_ENTITY : TypeJudgementKind.PROBABLY_NON_CONSTRUCTABLE_ENTITY;
        }

        public <T> T createEntity(Class<T> clazz) {
            return (T)ObjenesisHelper.newInstance(clazz);
        }

        public boolean hasProperty(Object object, String property) {
            if (object == null || property == null) {
                throw new NullPointerException();
            }
            EntityPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object.getClass(), property);
            return propertyDescriptor != null;
        }

        public Object getProperty(Object object, String property, boolean explicit) {
            if (object == null || property == null) {
                throw new NullPointerException();
            }
            EntityPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object.getClass(), property);
            if (propertyDescriptor == null || propertyDescriptor.getReadAccessor() == null) {
                if (explicit) {
                    throw new HussarIntegrationEntityException("cannot read property '" + property + "' of class " + object.getClass());
                }
                return null;
            }
            return propertyDescriptor.getReadAccessor().read(object);
        }

        public void setProperty(Object object, String property, Object value, boolean explicit) {
            if (object == null || property == null) {
                throw new NullPointerException();
            }
            EntityPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object.getClass(), property);
            if (propertyDescriptor == null || propertyDescriptor.getWriteAccessor() == null) {
                if (explicit) {
                    throw new HussarIntegrationEntityException("cannot write property '" + property + "' of class " + object.getClass());
                }
                return;
            }
            propertyDescriptor.getWriteAccessor().write(object, value);
        }

        public void copyProperties(Object target, Object source) {
            if (target == null || source == null) {
                throw new NullPointerException();
            }
            Map<String, EntityPropertyDescriptor> writableProperties = this.getWritableProperties(target.getClass());
            Map<String, EntityPropertyDescriptor> readableProperties = this.getReadableProperties(source.getClass());
            for (EntityPropertyDescriptor writableProperty : writableProperties.values()) {
                Class<?> readRawType;
                Class<?> writeRawType;
                String propertyName = writableProperty.getName();
                EntityPropertyDescriptor readableProperty = readableProperties.get(propertyName);
                if (readableProperty == null) continue;
                EntityMemberAccessor readAccessor = readableProperty.getReadAccessor();
                EntityMemberAccessor writeAccessor = writableProperty.getWriteAccessor();
                if (readAccessor == null || writeAccessor == null || !(writeRawType = readAccessor.getRawType()).isAssignableFrom(readRawType = writeAccessor.getRawType())) continue;
                Object value = readAccessor.read(source);
                writeAccessor.write(target, value);
            }
        }

        public Map<String, EntityPropertyDescriptor> getProperties(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            return this.getIntrospectData(clazz).getProperties();
        }

        public EntityPropertyDescriptor getPropertyDescriptor(Class<?> clazz, String property) {
            if (clazz == null || property == null) {
                throw new NullPointerException();
            }
            return this.getIntrospectData(clazz).getProperties().get(property);
        }

        public Map<String, EntityPropertyDescriptor> getReadableProperties(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            LinkedHashMap<String, EntityPropertyDescriptor> descriptors = new LinkedHashMap<String, EntityPropertyDescriptor>();
            for (EntityPropertyDescriptor descriptor : this.getIntrospectData(clazz).getProperties().values()) {
                if (!descriptor.isReadable()) continue;
                descriptors.put(descriptor.getName(), descriptor);
            }
            return Collections.unmodifiableMap(descriptors);
        }

        public Map<String, EntityPropertyDescriptor> getWritableProperties(Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException();
            }
            LinkedHashMap<String, EntityPropertyDescriptor> descriptors = new LinkedHashMap<String, EntityPropertyDescriptor>();
            for (EntityPropertyDescriptor descriptor : this.getIntrospectData(clazz).getProperties().values()) {
                if (!descriptor.isWritable()) continue;
                descriptors.put(descriptor.getName(), descriptor);
            }
            return Collections.unmodifiableMap(descriptors);
        }

        private IntrospectData getIntrospectData(Class<?> clazz) {
            return this.introspectCache.computeIfAbsent(clazz, this::introspect);
        }

        private IntrospectData introspect(Class<?> clazz) {
            ArrayList<EntityPropertyDescriptor> uncategorizedPropertyDescriptors = new ArrayList<EntityPropertyDescriptor>();
            for (Field field : clazz.getFields()) {
                int modifiers = field.getModifiers();
                if (field.isSynthetic() || Modifier.isStatic(modifiers) || HussarIntegrationEntityUtils.isIgnorableSpecialField(field)) continue;
                String fieldName = field.getName();
                EntityProperty annotation = this.getEntityPropertyAnnotation(field);
                if (annotation != null && StringUtils.isNotEmpty((CharSequence)annotation.value())) {
                    fieldName = annotation.value();
                }
                boolean writable = !Modifier.isFinal(modifiers);
                Class<?> rawType = field.getType();
                Type genericType = field.getGenericType();
                EntityFieldAccessor fieldAccessor = new EntityFieldAccessor(fieldName, writable, rawType, genericType, field);
                uncategorizedPropertyDescriptors.add(EntityPropertyDescriptor.of(fieldName, fieldAccessor));
            }
            for (PropertyDescriptor descriptor : this.getPropertyUtils().getPropertyDescriptors(clazz)) {
                String readName = null;
                EntityPropertyAccessor readAccessor = null;
                Method readMethod = descriptor.getReadMethod();
                if (readMethod != null) {
                    boolean ignore;
                    EntityProperty methodAnnotation = this.getEntityPropertyAnnotation(readMethod);
                    EntityProperty underlyingFieldAnnotation = this.getUnderlyingFieldAnnotation(descriptor.getName(), readMethod);
                    readName = methodAnnotation != null && StringUtils.isNotEmpty((CharSequence)methodAnnotation.value()) ? methodAnnotation.value() : (underlyingFieldAnnotation != null && StringUtils.isNotEmpty((CharSequence)underlyingFieldAnnotation.value()) ? underlyingFieldAnnotation.value() : descriptor.getName());
                    boolean bl = ignore = methodAnnotation != null && methodAnnotation.ignore() || underlyingFieldAnnotation != null && underlyingFieldAnnotation.ignore() || HussarIntegrationEntityUtils.isIgnorableSpecialGetter(readMethod);
                    if (!ignore) {
                        Class<?> rawType = readMethod.getReturnType();
                        Type genericType = readMethod.getGenericReturnType();
                        readAccessor = new EntityPropertyAccessor(readName, false, rawType, genericType, readMethod);
                    }
                }
                String writeName = null;
                EntityPropertyAccessor writeAccessor = null;
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod != null) {
                    boolean ignore;
                    EntityProperty methodAnnotation = this.getEntityPropertyAnnotation(writeMethod);
                    EntityProperty underlyingFieldAnnotation = this.getUnderlyingFieldAnnotation(descriptor.getName(), writeMethod);
                    writeName = methodAnnotation != null && StringUtils.isNotEmpty((CharSequence)methodAnnotation.value()) ? methodAnnotation.value() : (underlyingFieldAnnotation != null && StringUtils.isNotEmpty((CharSequence)underlyingFieldAnnotation.value()) ? underlyingFieldAnnotation.value() : descriptor.getName());
                    boolean bl = ignore = methodAnnotation != null && methodAnnotation.ignore() || underlyingFieldAnnotation != null && underlyingFieldAnnotation.ignore() || HussarIntegrationEntityUtils.isIgnorableSpecialSetter(writeMethod);
                    if (!ignore) {
                        Parameter[] parameters = writeMethod.getParameters();
                        Type[] genericParameterTypes = writeMethod.getGenericParameterTypes();
                        if (parameters.length == 1) {
                            Class<?> rawType = parameters[0].getType();
                            Type genericType = genericParameterTypes.length > 0 ? genericParameterTypes[0] : null;
                            writeAccessor = new EntityPropertyAccessor(writeName, true, rawType, genericType, writeMethod);
                        }
                    }
                }
                if (readAccessor != null && writeAccessor != null) {
                    if (Objects.equals(readName, writeName)) {
                        uncategorizedPropertyDescriptors.add(EntityPropertyDescriptor.of(readName, readAccessor, writeAccessor));
                        continue;
                    }
                    uncategorizedPropertyDescriptors.add(EntityPropertyDescriptor.of(readName, readAccessor, null));
                    uncategorizedPropertyDescriptors.add(EntityPropertyDescriptor.of(writeName, null, writeAccessor));
                    continue;
                }
                if (readAccessor != null) {
                    uncategorizedPropertyDescriptors.add(EntityPropertyDescriptor.of(readName, readAccessor, null));
                }
                if (writeAccessor == null) continue;
                uncategorizedPropertyDescriptors.add(EntityPropertyDescriptor.of(writeName, null, writeAccessor));
            }
            LinkedHashMap<String, EntityPropertyDescriptor> propertyDescriptors = new LinkedHashMap<String, EntityPropertyDescriptor>();
            for (EntityPropertyDescriptor propertyDescriptor : uncategorizedPropertyDescriptors) {
                EntityPropertyDescriptor previousPropertyDescriptor = (EntityPropertyDescriptor)propertyDescriptors.get(propertyDescriptor.getName());
                if (previousPropertyDescriptor == null) {
                    propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
                    continue;
                }
                if (logger.isWarnEnabled()) {
                    if (propertyDescriptor.getReadAccessor() != null && previousPropertyDescriptor.getReadAccessor() != null) {
                        logger.warn("introspected duplicated property read accessor for '{}': {} <=> {}", new Object[]{propertyDescriptor.getName(), propertyDescriptor.getReadAccessor(), previousPropertyDescriptor.getReadAccessor()});
                    }
                    if (propertyDescriptor.getWriteAccessor() != null && previousPropertyDescriptor.getWriteAccessor() != null) {
                        logger.warn("introspected duplicated property write accessor for '{}': {} <=> {}", new Object[]{propertyDescriptor.getName(), propertyDescriptor.getWriteAccessor(), previousPropertyDescriptor.getWriteAccessor()});
                    }
                }
                EntityPropertyDescriptor mergedPropertyDescriptor = EntityPropertyDescriptor.of(propertyDescriptor.getName(), propertyDescriptor.getField() != null ? propertyDescriptor.getField() : previousPropertyDescriptor.getField(), propertyDescriptor.getGetter() != null ? propertyDescriptor.getGetter() : previousPropertyDescriptor.getGetter(), propertyDescriptor.getSetter() != null ? propertyDescriptor.getSetter() : previousPropertyDescriptor.getSetter());
                propertyDescriptors.put(mergedPropertyDescriptor.getName(), mergedPropertyDescriptor);
            }
            return new IntrospectData(clazz, propertyDescriptors);
        }

        private EntityProperty getUnderlyingFieldAnnotation(String property, Method accessor) {
            Class<?> clazz = accessor.getDeclaringClass();
            try {
                Field field = clazz.getDeclaredField(property);
                return this.getEntityPropertyAnnotation(field);
            }
            catch (NoSuchFieldException ignore) {
                return null;
            }
        }

        private EntityProperty getEntityPropertyAnnotation(AnnotatedElement annotatedElement) {
            EntityProperty annotation = annotatedElement.getAnnotation(EntityProperty.class);
            if (annotation != null) {
                return annotation;
            }
            return this.getAnnotationMagician().getAnnotation(annotatedElement, EntityProperty.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyUtilsBean getPropertyUtils() {
            PropertyUtilsBean target;
            if (this.propertyUtils == null || (target = this.propertyUtils.get()) == null) {
                EntityUtilsBean entityUtilsBean = this;
                synchronized (entityUtilsBean) {
                    if (this.propertyUtils == null || (target = this.propertyUtils.get()) == null) {
                        target = new PropertyUtilsBean();
                        this.propertyUtils = this.oneshot ? new WeakReference<PropertyUtilsBean>(target) : new SoftReference<PropertyUtilsBean>(target);
                    }
                }
            }
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AnnotationMagician getAnnotationMagician() {
            AnnotationMagician target;
            if (this.annotationMagician == null || (target = this.annotationMagician.get()) == null) {
                EntityUtilsBean entityUtilsBean = this;
                synchronized (entityUtilsBean) {
                    if (this.annotationMagician == null || (target = this.annotationMagician.get()) == null) {
                        target = new AnnotationMagician();
                        this.annotationMagician = this.oneshot ? new WeakReference<AnnotationMagician>(target) : new SoftReference<AnnotationMagician>(target);
                    }
                }
            }
            return target;
        }
    }
}

