/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.utils;

import com.jxdinfo.hussar.integration.support.convert.AbstractConvertContext;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.convert.provider.CoreConverterProvider;
import com.jxdinfo.hussar.integration.support.convert.provider.ExtraConverterProvider;
import com.jxdinfo.hussar.integration.support.convert.spi.ConverterProvider;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import java.util.ArrayList;
import java.util.List;

public final class HussarIntegrationConvertUtils {
    private static volatile ConvertUtilsBean BEAN = null;

    private HussarIntegrationConvertUtils() {
    }

    public static <T> T convert(Object value, Class<T> clazz) {
        return HussarIntegrationConvertUtils.getUtilsBean().convert(value, clazz);
    }

    public static <T> T convert(Object value, TypeReference<T> typeReference) {
        return HussarIntegrationConvertUtils.getUtilsBean().convert(value, typeReference);
    }

    public static ConvertUtilsBean createUtilsBean(String ... features) {
        return new ConvertUtilsBean(features);
    }

    public static ConvertUtilsBean createUtilsBean(boolean oneshot, String ... features) {
        return new ConvertUtilsBean(oneshot, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ConvertUtilsBean getUtilsBean() {
        if (BEAN != null) return BEAN;
        Class<HussarIntegrationConvertUtils> clazz = HussarIntegrationConvertUtils.class;
        synchronized (HussarIntegrationConvertUtils.class) {
            if (BEAN != null) return BEAN;
            BEAN = HussarIntegrationConvertUtils.createUtilsBean(new String[0]);
            // ** MonitorExit[var0] (shouldn't be in output)
            return BEAN;
        }
    }

    private static final class DefaultConverterProviderOptions
    implements ConverterProvider.Options {
        private boolean oneshot;

        private DefaultConverterProviderOptions() {
        }

        @Override
        public boolean isOneshot() {
            return this.oneshot;
        }

        public void setOneshot(boolean oneshot) {
            this.oneshot = oneshot;
        }
    }

    private static final class DefaultConvertContext
    extends AbstractConvertContext {
        public DefaultConvertContext() {
            this(false, new String[0]);
        }

        public DefaultConvertContext(boolean oneshot, String ... features) {
            super(oneshot, DefaultConvertContext.getConverterProviderOptions(oneshot), DefaultConvertContext.getConverterProviders(), features);
        }

        private static ConverterProvider.Options getConverterProviderOptions(boolean oneshot) {
            DefaultConverterProviderOptions options = new DefaultConverterProviderOptions();
            options.setOneshot(oneshot);
            return options;
        }

        private static List<ConverterProvider> getConverterProviders() {
            ArrayList<ConverterProvider> converterProviders = new ArrayList<ConverterProvider>();
            converterProviders.add(new CoreConverterProvider());
            converterProviders.add(new ExtraConverterProvider());
            List<ConverterProvider> thirdPartyConverterProviders = DefaultConvertContext.findConverterProviders();
            converterProviders.addAll(thirdPartyConverterProviders);
            return converterProviders;
        }
    }

    public static final class ConvertUtilsBean {
        private final ConvertContext context;

        public ConvertUtilsBean(String ... features) {
            this(false, features);
        }

        public ConvertUtilsBean(boolean oneshot, String ... features) {
            this(new DefaultConvertContext(oneshot, features));
        }

        private ConvertUtilsBean(ConvertContext context) {
            this.context = context;
        }

        public <T> T convert(Object value, Class<T> clazz) {
            return this.context.convert(value, clazz);
        }

        public <T> T convert(Object value, TypeReference<T> typeReference) {
            return this.context.convert(value, typeReference.getType());
        }
    }
}

