/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.multipart.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.jxdinfo.hussar.integration.support.jackson.multipart.ser.AbstractMultipartFileSerializer;
import java.io.IOException;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileSerializer
extends AbstractMultipartFileSerializer<MultipartFile> {
    private final boolean briefMode;

    public MultipartFileSerializer(boolean briefMode) {
        super(MultipartFile.class);
        this.briefMode = briefMode;
    }

    @Override
    protected boolean skipBytes() {
        return this.briefMode;
    }

    @Override
    protected void serializeAdditionalProperties(MultipartFile value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        long size;
        if (this.briefMode && (size = value.getSize()) > 0L) {
            gen.writeNumberField("size", size);
        }
    }
}

