/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.multipart.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractMultipartFileSerializer<T extends MultipartFile>
extends StdSerializer<T> {
    public AbstractMultipartFileSerializer(Class<T> t) {
        super(t);
    }

    public AbstractMultipartFileSerializer(JavaType type) {
        super(type);
    }

    public AbstractMultipartFileSerializer(Class<?> t, boolean dummy) {
        super(t, dummy);
    }

    public AbstractMultipartFileSerializer(StdSerializer<?> src) {
        super(src);
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        gen.writeStartObject();
        this.serializeCommonProperties(value, gen, provider);
        this.serializeAdditionalProperties(value, gen, provider);
        gen.writeEndObject();
    }

    protected void serializeCommonProperties(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        String originalFilename;
        gen.writeStringField("name", value.getName());
        String contentType = value.getContentType();
        if (contentType != null) {
            gen.writeStringField("contentType", contentType);
        }
        if ((originalFilename = value.getOriginalFilename()) != null) {
            gen.writeStringField("originalFilename", originalFilename);
        }
        if (!this.skipBytes()) {
            byte[] bytes;
            try {
                bytes = value.getBytes();
            }
            catch (IOException ex) {
                throw JsonMappingException.wrapWithPath((Throwable)ex, value, (String)"bytes");
            }
            gen.writeFieldName("bytes");
            gen.writeBinary(bytes);
        }
    }

    protected boolean skipBytes() {
        return false;
    }

    protected void serializeAdditionalProperties(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
    }
}

