/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.multipart.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractMultipartFileDeserializer<T extends MultipartFile>
extends StdDeserializer<T> {
    public AbstractMultipartFileDeserializer(Class<?> vc) {
        super(vc);
    }

    public AbstractMultipartFileDeserializer(JavaType valueType) {
        super(valueType);
    }

    public AbstractMultipartFileDeserializer(StdDeserializer<?> src) {
        super(src);
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        if (parser.hasTokenId(11)) {
            return null;
        }
        if (parser.isExpectedStartObjectToken()) {
            ParsedMultipartFile parsed = new ParsedMultipartFile();
            JsonDeserializer stringDeserializer = context.findNonContextualValueDeserializer(context.getTypeFactory().constructType(String.class));
            JsonDeserializer bytesDeserializer = context.findNonContextualValueDeserializer(context.getTypeFactory().constructType(byte[].class));
            JsonToken token = parser.nextToken();
            while (token != JsonToken.END_OBJECT) {
                String field;
                if (token != JsonToken.FIELD_NAME) {
                    return (T)((MultipartFile)this.handleUnexpectedToken(context, parser, "expects field name", new Object[0]));
                }
                switch (field = parser.getCurrentName()) {
                    case "name": {
                        parser.nextToken();
                        parsed.setName((String)stringDeserializer.deserialize(parser, context));
                        break;
                    }
                    case "contentType": {
                        parser.nextToken();
                        parsed.setContentType((String)stringDeserializer.deserialize(parser, context));
                        break;
                    }
                    case "originalFilename": {
                        parser.nextToken();
                        parsed.setOriginalFilename((String)stringDeserializer.deserialize(parser, context));
                        break;
                    }
                    case "bytes": {
                        parser.nextToken();
                        parsed.setBytes((byte[])bytesDeserializer.deserialize(parser, context));
                        break;
                    }
                    default: {
                        parser.nextToken();
                        this.parseAdditionalProperty(field, parsed, parser, context);
                    }
                }
                token = parser.nextToken();
            }
            if (parsed.isEmpty()) {
                return null;
            }
            return this.constructMultipartFile(parsed, context);
        }
        return (T)((MultipartFile)this.handleUnexpectedToken(context, parser, "expects json object", new Object[0]));
    }

    protected abstract T constructMultipartFile(ParsedMultipartFile var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    protected void parseAdditionalProperty(String name, ParsedMultipartFile parsed, JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        this.handleUnknownProperty(parser, context, null, name);
    }

    protected <R> R handleUnexpectedToken(DeserializationContext context, JsonParser parser, String message, Object ... args) throws JsonMappingException {
        try {
            return (R)context.handleUnexpectedToken(this.handledType(), parser.getCurrentToken(), parser, message, args);
        }
        catch (JsonMappingException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw JsonMappingException.fromUnexpectedIOE((IOException)ex);
        }
    }

    protected <R> R handleInstantiationProblem(DeserializationContext context, Throwable throwable) throws JsonMappingException {
        try {
            return (R)context.handleInstantiationProblem(this.handledType(), null, throwable);
        }
        catch (JsonMappingException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw JsonMappingException.fromUnexpectedIOE((IOException)ex);
        }
    }

    public static class ParsedMultipartFile {
        private String name;
        private String contentType;
        private String originalFilename;
        private byte[] bytes;
        private Map<String, Object> additionalProperties;

        public boolean isEmpty() {
            return this.name == null && this.contentType == null && this.originalFilename == null && this.bytes == null && this.additionalProperties == null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getOriginalFilename() {
            return this.originalFilename;
        }

        public void setOriginalFilename(String originalFilename) {
            this.originalFilename = originalFilename;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        public void addAdditionalProperty(String name, Object value) {
            if (this.additionalProperties == null) {
                this.additionalProperties = new LinkedHashMap<String, Object>();
            }
            this.additionalProperties.put(name, value);
        }

        public void setAdditionalProperties(Map<String, Object> additionalProperties) {
            this.additionalProperties = additionalProperties;
        }
    }
}

