/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.multipart;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.jxdinfo.hussar.integration.support.common.multipart.ByteArrayMultipartFile;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonConfiguration;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonMultipartFileStrategy;
import com.jxdinfo.hussar.integration.support.jackson.multipart.deser.ByteArrayMultipartFileDeserializer;
import com.jxdinfo.hussar.integration.support.jackson.multipart.deser.MultipartFileDeserializer;
import com.jxdinfo.hussar.integration.support.jackson.multipart.ser.MultipartFileSerializer;
import java.util.Optional;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileModule
extends SimpleModule {
    public MultipartFileModule(JsonConfiguration configuration) {
        super(PackageVersion.VERSION);
        JsonMultipartFileStrategy strategy = Optional.ofNullable(configuration).map(JsonConfiguration::getMultipartFileStrategy).orElse(JsonMultipartFileStrategy.NOT_SUPPORT);
        switch (strategy) {
            case NOT_SUPPORT: {
                break;
            }
            case FULL_CONTENT: {
                this.addSerializer(MultipartFile.class, (JsonSerializer)new MultipartFileSerializer(false));
                this.addDeserializer(MultipartFile.class, (JsonDeserializer)new MultipartFileDeserializer());
                this.addDeserializer(ByteArrayMultipartFile.class, (JsonDeserializer)new ByteArrayMultipartFileDeserializer());
                break;
            }
            case BRIEF_INFO: {
                this.addSerializer(MultipartFile.class, (JsonSerializer)new MultipartFileSerializer(true));
                this.addDeserializer(MultipartFile.class, (JsonDeserializer)new MultipartFileDeserializer());
                this.addDeserializer(ByteArrayMultipartFile.class, (JsonDeserializer)new ByteArrayMultipartFileDeserializer());
            }
        }
    }
}

