/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.datetime.ser.internal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public abstract class LegacyDateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final Boolean useTimestamp;
    protected final DateTimeFormatter formatter;

    protected LegacyDateTimeSerializerBase(Class<T> type, Boolean useTimestamp, DateTimeFormatter formatter) {
        super(type);
        this.useTimestamp = useTimestamp;
        this.formatter = formatter;
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format == null) {
            return this;
        }
        if (format.getShape().isNumeric()) {
            return this.withFormat(Boolean.TRUE, null);
        }
        DateTimeFormatter formatter = this.formatter;
        if (format.hasPattern()) {
            String pattern = format.getPattern();
            Locale locale = format.hasLocale() ? format.getLocale() : serializers.getLocale();
            formatter = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
            if (format.hasTimeZone()) {
                formatter = formatter.withZone(format.getTimeZone().toZoneId());
            }
        }
        return this.withFormat(Boolean.FALSE, formatter);
    }

    public abstract LegacyDateTimeSerializerBase<T> withFormat(Boolean var1, DateTimeFormatter var2);

    public JsonNode getSchema(SerializerProvider serializers, Type typeHint) {
        return this.createSchemaNode(this.useTimestamp(serializers) ? "number" : "string", true);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this.useTimestamp(visitor.getProvider())) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.LONG, JsonValueFormat.UTC_MILLISEC);
        } else {
            this.visitStringFormat(visitor, typeHint, JsonValueFormat.DATE_TIME);
        }
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (this.useTimestamp(serializers)) {
            Long timestamp = this.timestamp(value);
            if (timestamp != null) {
                gen.writeNumber(timestamp.longValue());
            } else {
                gen.writeNull();
            }
            return;
        }
        String string = this.format(value);
        if (string != null) {
            gen.writeString(string);
        } else {
            gen.writeNull();
        }
    }

    protected boolean useTimestamp(SerializerProvider serializers) {
        if (this.useTimestamp != null) {
            return this.useTimestamp;
        }
        if (serializers != null) {
            return serializers.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return false;
    }

    protected abstract Long timestamp(T var1);

    protected abstract String format(T var1);
}

