/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.datetime.ser;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.formating.TemporalFormatingRule;
import com.jxdinfo.hussar.integration.support.jackson.datetime.ser.internal.LegacyDateTimeSerializerBase;
import java.sql.Date;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ExtendedSqlDateSerializer
extends LegacyDateTimeSerializerBase<Date> {
    private final DateTimeHelper helper;

    public ExtendedSqlDateSerializer(DateTimeHelper helper, DateTimeFormatter formatter) {
        super(Date.class, null, formatter);
        this.helper = helper;
    }

    protected ExtendedSqlDateSerializer(ExtendedSqlDateSerializer base, Boolean useTimestamp, DateTimeFormatter formatter) {
        super(Date.class, useTimestamp, formatter);
        this.helper = base.helper.toBuilder().addTemporalFormatingRule(TemporalFormatingRule.of(ZonedDateTime.class, formatter)).build();
    }

    @Override
    protected Long timestamp(Date value) {
        return this.helper.toTimestamp(value);
    }

    @Override
    protected String format(Date value) {
        if (value == null) {
            return null;
        }
        ZonedDateTime temporal = this.helper.toZonedDateTime(value);
        String string = this.helper.toString(temporal);
        if (string == null) {
            throw new IllegalStateException("cannot format date");
        }
        return string;
    }

    public ExtendedSqlDateSerializer withFormat(Boolean useTimestamp, DateTimeFormatter formatter) {
        return new ExtendedSqlDateSerializer(this, useTimestamp, formatter);
    }
}

