/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.datetime.deser.internal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public abstract class LegacyDateDeserializerBase<T>
extends StdScalarDeserializer<T>
implements ContextualDeserializer {
    protected final DateTimeFormatter formatter;

    protected LegacyDateDeserializerBase(Class<T> type, DateTimeFormatter formatter) {
        super(type);
        this.formatter = formatter;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format = this.findFormatOverrides(context, property, this.handledType());
        if (format == null) {
            return this;
        }
        DateTimeFormatter formatter = this.formatter;
        if (format.hasPattern()) {
            String pattern = format.getPattern();
            Locale locale = format.hasLocale() ? format.getLocale() : context.getLocale();
            formatter = locale == null ? DateTimeFormatter.ofPattern(pattern) : DateTimeFormatter.ofPattern(pattern, locale);
            if (format.hasTimeZone()) {
                formatter = formatter.withZone(format.getTimeZone().toZoneId());
            }
        }
        return this.withFormat(formatter);
    }

    protected abstract LegacyDateDeserializerBase<T> withFormat(DateTimeFormatter var1);

    protected <R> R handleUnexpectedToken(DeserializationContext context, JsonParser parser, String message, Object ... args) throws JsonMappingException {
        try {
            return (R)context.handleUnexpectedToken(this.handledType(), parser.getCurrentToken(), parser, message, args);
        }
        catch (JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE((IOException)e);
        }
    }
}

