/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.datetime.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.recognize.TemporalRecognitionRule;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ExtendedLocalTimeDeserializer
extends LocalTimeDeserializer {
    private final DateTimeHelper helper;

    public ExtendedLocalTimeDeserializer(DateTimeHelper helper, DateTimeFormatter formatter) {
        super(formatter);
        this.helper = helper;
    }

    protected ExtendedLocalTimeDeserializer(ExtendedLocalTimeDeserializer base, DateTimeFormatter formatter) {
        super(formatter);
        this.helper = base.helper.toBuilder().addTemporalRecognitionRule(TemporalRecognitionRule.of(LocalTime.class, formatter, LocalTime::parse)).build();
    }

    protected ExtendedLocalTimeDeserializer(ExtendedLocalTimeDeserializer base, Boolean leniency) {
        super(base._formatter);
        this.helper = base.helper;
    }

    public LocalTime deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        if (parser.hasTokenId(11)) {
            return null;
        }
        if (parser.hasTokenId(6)) {
            String string = StringUtils.trim((String)parser.getText());
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            LocalTime parsed = this.helper.toLocalTime(string);
            if (parsed == null) {
                throw context.weirdStringException(string, LocalTime.class, "cannot recognize time string");
            }
            return parsed;
        }
        if (parser.hasTokenId(7)) {
            LocalTime parsed;
            long timestamp = parser.getLongValue();
            LocalTime localTime = parsed = timestamp >= 0L ? this.helper.toLocalTime(timestamp) : null;
            if (parsed == null) {
                throw context.weirdNumberException((Number)timestamp, LocalTime.class, "cannot recognize timestamp number");
            }
            return parsed;
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            Object object = parser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof LocalTime) {
                return (LocalTime)object;
            }
            if (object instanceof CharSequence) {
                String string = ((CharSequence)object).toString();
                LocalTime parsed = this.helper.toLocalTime(string);
                if (parsed == null) {
                    throw context.weirdStringException(string, LocalTime.class, "cannot convert embedded time string");
                }
                return parsed;
            }
            if (object instanceof Number) {
                LocalTime parsed;
                long timestamp = ((Number)object).longValue();
                LocalTime localTime = parsed = timestamp >= 0L ? this.helper.toLocalTime(timestamp) : null;
                if (parsed == null) {
                    throw context.weirdNumberException((Number)object, LocalTime.class, "cannot convert embedded timestamp number");
                }
                return parsed;
            }
            if (object instanceof TemporalAccessor) {
                LocalTime parsed = this.helper.toLocalTime((TemporalAccessor)object);
                if (parsed == null) {
                    throw context.weirdNativeValueException(object, LocalTime.class);
                }
                return parsed;
            }
            if (object instanceof Date) {
                LocalTime parsed = this.helper.toLocalTime((Date)object);
                if (parsed == null) {
                    throw context.weirdNativeValueException(object, LocalTime.class);
                }
                return parsed;
            }
            throw context.weirdNativeValueException(object, LocalTime.class);
        }
        return super.deserialize(parser, context);
    }

    protected ExtendedLocalTimeDeserializer withDateFormat(DateTimeFormatter formatter) {
        return new ExtendedLocalTimeDeserializer(this, formatter);
    }

    protected ExtendedLocalTimeDeserializer withLeniency(Boolean leniency) {
        return new ExtendedLocalTimeDeserializer(this, leniency);
    }
}

