/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.datetime.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.recognize.TemporalRecognitionRule;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ExtendedLocalDateTimeDeserializer
extends LocalDateTimeDeserializer {
    private final DateTimeHelper helper;

    public ExtendedLocalDateTimeDeserializer(DateTimeHelper helper, DateTimeFormatter formatter) {
        super(formatter);
        this.helper = helper;
    }

    protected ExtendedLocalDateTimeDeserializer(ExtendedLocalDateTimeDeserializer base, DateTimeFormatter formatter) {
        super(formatter);
        this.helper = base.helper.toBuilder().addTemporalRecognitionRule(TemporalRecognitionRule.of(LocalDateTime.class, formatter, LocalDateTime::parse)).build();
    }

    protected ExtendedLocalDateTimeDeserializer(ExtendedLocalDateTimeDeserializer base, Boolean leniency) {
        super((LocalDateTimeDeserializer)base, leniency);
        this.helper = base.helper;
    }

    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        if (parser.hasTokenId(11)) {
            return null;
        }
        if (parser.hasTokenId(6)) {
            String string = StringUtils.trim((String)parser.getText());
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            LocalDateTime parsed = this.helper.toLocalDateTime(string);
            if (parsed == null) {
                throw context.weirdStringException(string, LocalDateTime.class, "cannot recognize date time string");
            }
            return parsed;
        }
        if (parser.hasTokenId(7)) {
            LocalDateTime parsed;
            long timestamp = parser.getLongValue();
            LocalDateTime localDateTime = parsed = timestamp >= 0L ? this.helper.toLocalDateTime(timestamp) : null;
            if (parsed == null) {
                throw context.weirdNumberException((Number)timestamp, LocalDateTime.class, "cannot recognize timestamp number");
            }
            return parsed;
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            Object object = parser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof LocalDateTime) {
                return (LocalDateTime)object;
            }
            if (object instanceof CharSequence) {
                String string = ((CharSequence)object).toString();
                LocalDateTime parsed = this.helper.toLocalDateTime(string);
                if (parsed == null) {
                    throw context.weirdStringException(string, LocalDateTime.class, "cannot convert embedded date time string");
                }
                return parsed;
            }
            if (object instanceof Number) {
                LocalDateTime parsed;
                long timestamp = ((Number)object).longValue();
                LocalDateTime localDateTime = parsed = timestamp >= 0L ? this.helper.toLocalDateTime(timestamp) : null;
                if (parsed == null) {
                    throw context.weirdNumberException((Number)object, LocalDateTime.class, "cannot convert embedded timestamp number");
                }
                return parsed;
            }
            if (object instanceof TemporalAccessor) {
                LocalDateTime parsed = this.helper.toLocalDateTime((TemporalAccessor)object);
                if (parsed == null) {
                    throw context.weirdNativeValueException(object, LocalDateTime.class);
                }
                return parsed;
            }
            if (object instanceof Date) {
                LocalDateTime parsed = this.helper.toLocalDateTime((Date)object);
                if (parsed == null) {
                    throw context.weirdNativeValueException(object, LocalDateTime.class);
                }
                return parsed;
            }
            throw context.weirdNativeValueException(object, LocalDateTime.class);
        }
        return super.deserialize(parser, context);
    }

    protected ExtendedLocalDateTimeDeserializer withDateFormat(DateTimeFormatter formatter) {
        return new ExtendedLocalDateTimeDeserializer(this, formatter);
    }

    protected ExtendedLocalDateTimeDeserializer withLeniency(Boolean leniency) {
        return new ExtendedLocalDateTimeDeserializer(this, leniency);
    }
}

