/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.datetime.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.recognize.TemporalRecognitionRule;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ExtendedLocalDateDeserializer
extends LocalDateDeserializer {
    private final DateTimeHelper helper;

    public ExtendedLocalDateDeserializer(DateTimeHelper helper, DateTimeFormatter formatter) {
        super(formatter);
        this.helper = helper;
    }

    public ExtendedLocalDateDeserializer(ExtendedLocalDateDeserializer base, DateTimeFormatter formatter) {
        super((LocalDateDeserializer)base, formatter);
        this.helper = base.helper.toBuilder().addTemporalRecognitionRule(TemporalRecognitionRule.of(LocalDate.class, formatter, LocalDate::parse)).build();
    }

    protected ExtendedLocalDateDeserializer(ExtendedLocalDateDeserializer base, Boolean leniency) {
        super((LocalDateDeserializer)base, leniency);
        this.helper = base.helper;
    }

    public LocalDate deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        if (parser.hasTokenId(11)) {
            return null;
        }
        if (parser.hasTokenId(6)) {
            String string = StringUtils.trim((String)parser.getText());
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            LocalDate parsed = this.helper.toLocalDate(string);
            if (parsed == null) {
                throw context.weirdStringException(string, LocalDate.class, "cannot recognize date string");
            }
            return parsed;
        }
        if (parser.hasTokenId(7)) {
            LocalDate parsed;
            long timestamp = parser.getLongValue();
            LocalDate localDate = parsed = timestamp >= 0L ? this.helper.toLocalDate(timestamp) : null;
            if (parsed == null) {
                throw context.weirdNumberException((Number)timestamp, LocalDate.class, "cannot recognize timestamp number");
            }
            return parsed;
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            Object object = parser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof LocalDate) {
                return (LocalDate)object;
            }
            if (object instanceof CharSequence) {
                String string = ((CharSequence)object).toString();
                LocalDate parsed = this.helper.toLocalDate(string);
                if (parsed == null) {
                    throw context.weirdStringException(string, LocalDate.class, "cannot convert embedded date string");
                }
                return parsed;
            }
            if (object instanceof Number) {
                LocalDate parsed;
                long timestamp = ((Number)object).longValue();
                LocalDate localDate = parsed = timestamp >= 0L ? this.helper.toLocalDate(timestamp) : null;
                if (parsed == null) {
                    throw context.weirdNumberException((Number)object, LocalDate.class, "cannot convert embedded timestamp number");
                }
                return parsed;
            }
            if (object instanceof TemporalAccessor) {
                LocalDate parsed = this.helper.toLocalDate((TemporalAccessor)object);
                if (parsed == null) {
                    throw context.weirdNativeValueException(object, LocalDate.class);
                }
                return parsed;
            }
            if (object instanceof Date) {
                LocalDate parsed = this.helper.toLocalDate((Date)object);
                if (parsed == null) {
                    throw context.weirdNativeValueException(object, LocalDate.class);
                }
                return parsed;
            }
            throw context.weirdNativeValueException(object, LocalDate.class);
        }
        return super.deserialize(parser, context);
    }

    protected ExtendedLocalDateDeserializer withDateFormat(DateTimeFormatter formatter) {
        return new ExtendedLocalDateDeserializer(this, formatter);
    }

    protected ExtendedLocalDateDeserializer withLeniency(Boolean leniency) {
        return new ExtendedLocalDateDeserializer(this, leniency);
    }
}

