/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.datetime.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.recognize.TemporalRecognitionRule;
import com.jxdinfo.hussar.integration.support.jackson.datetime.deser.internal.LegacyDateDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedDateDeserializer
extends LegacyDateDeserializerBase<Date> {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedDateDeserializer.class);
    private final DateTimeHelper helper;

    public ExtendedDateDeserializer(DateTimeHelper helper, DateTimeFormatter formatter) {
        super(Date.class, formatter);
        this.helper = helper;
    }

    protected ExtendedDateDeserializer(ExtendedDateDeserializer base, DateTimeFormatter formatter) {
        super(Date.class, formatter);
        DateTimeHelper.Builder builder = base.helper.toBuilder();
        try {
            TemporalRecognitionRule<TemporalAccessor> rule = TemporalRecognitionRule.ofFormatter(formatter);
            builder.addTemporalRecognitionRule(rule);
        }
        catch (DateTimeException ex) {
            logger.warn("cannot apply date formatter", (Throwable)ex);
        }
        this.helper = builder.build();
    }

    public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        if (parser.hasTokenId(11)) {
            return null;
        }
        if (parser.hasTokenId(6)) {
            String string = StringUtils.trim((String)parser.getText());
            if (StringUtils.isBlank((CharSequence)string)) {
                return null;
            }
            Date parsed = this.helper.toDate(string);
            if (parsed == null) {
                throw context.weirdStringException(string, LocalDate.class, "cannot recognize date string");
            }
            return parsed;
        }
        if (parser.hasTokenId(7)) {
            Date parsed;
            long timestamp = parser.getLongValue();
            Date date = parsed = timestamp >= 0L ? this.helper.toDate(timestamp) : null;
            if (parsed == null) {
                throw context.weirdNumberException((Number)timestamp, LocalDate.class, "cannot recognize timestamp number");
            }
            return parsed;
        }
        return (Date)this.handleUnexpectedToken(context, parser, "Expected string or number", new Object[0]);
    }

    @Override
    protected LegacyDateDeserializerBase<Date> withFormat(DateTimeFormatter formatter) {
        return new ExtendedDateDeserializer(this, formatter);
    }
}

