/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.datetime;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.jxdinfo.hussar.integration.support.common.constants.DateTimeConstants;
import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.formating.TemporalFormatingRule;
import com.jxdinfo.hussar.integration.support.common.datetime.recognize.TemporalRecognitionRule;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonConfiguration;
import com.jxdinfo.hussar.integration.support.jackson.datetime.deser.ExtendedDateDeserializer;
import com.jxdinfo.hussar.integration.support.jackson.datetime.deser.ExtendedLocalDateDeserializer;
import com.jxdinfo.hussar.integration.support.jackson.datetime.deser.ExtendedLocalDateTimeDeserializer;
import com.jxdinfo.hussar.integration.support.jackson.datetime.deser.ExtendedLocalTimeDeserializer;
import com.jxdinfo.hussar.integration.support.jackson.datetime.deser.ExtendedSqlDateDeserializer;
import com.jxdinfo.hussar.integration.support.jackson.datetime.ser.ExtendedDateSerializer;
import com.jxdinfo.hussar.integration.support.jackson.datetime.ser.ExtendedSqlDateSerializer;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ConcurrentReferenceHashMap;

public class ExtendedDateTimeModule
extends SimpleModule {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedDateTimeModule.class);
    private static final ConcurrentMap<String, DateTimeFormatter> cachedFormatters = new ConcurrentReferenceHashMap();
    private DateTimeHelper helper;
    private DateTimeFormatter dateTimeFormatter;
    private DateTimeFormatter dateFormatter;
    private DateTimeFormatter timeFormatter;

    public ExtendedDateTimeModule(JsonConfiguration configuration) {
        super(PackageVersion.VERSION);
        this.initialize(configuration);
        this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new ExtendedLocalDateTimeDeserializer(this.helper, this.dateTimeFormatter));
        this.addDeserializer(LocalDate.class, (JsonDeserializer)new ExtendedLocalDateDeserializer(this.helper, this.dateFormatter));
        this.addDeserializer(LocalTime.class, (JsonDeserializer)new ExtendedLocalTimeDeserializer(this.helper, this.timeFormatter));
        this.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(this.dateTimeFormatter));
        this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(this.dateFormatter));
        this.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(this.timeFormatter));
        this.addDeserializer(java.util.Date.class, (JsonDeserializer)new ExtendedDateDeserializer(this.helper, this.dateTimeFormatter));
        this.addDeserializer(Date.class, (JsonDeserializer)new ExtendedSqlDateDeserializer(this.helper, this.dateTimeFormatter));
        this.addSerializer(java.util.Date.class, (JsonSerializer)new ExtendedDateSerializer(this.helper, this.dateTimeFormatter));
        this.addSerializer(Date.class, (JsonSerializer)new ExtendedSqlDateSerializer(this.helper, this.dateTimeFormatter));
    }

    private void initialize(JsonConfiguration configuration) {
        String dateTimeFormat = Optional.ofNullable(configuration).map(JsonConfiguration::getDateTimeFormat).orElse("yyyy-MM-dd HH:mm:ss");
        String dateFormat = Optional.ofNullable(configuration).map(JsonConfiguration::getDateFormat).orElse("yyyy-MM-dd");
        String timeFormat = Optional.ofNullable(configuration).map(JsonConfiguration::getTimeFormat).orElse("HH:mm:ss");
        this.dateTimeFormatter = this.formatter(dateTimeFormat);
        this.dateFormatter = this.formatter(dateFormat);
        this.timeFormatter = this.formatter(timeFormat);
        List<TemporalRecognitionRule<? extends TemporalAccessor>> temporalRecognitionRules = Stream.of(this.recognitionRule(LocalDateTime.class, this.dateTimeFormatter, LocalDateTime::parse), this.recognitionRule(LocalDate.class, this.dateFormatter, LocalDate::parse), this.recognitionRule(LocalTime.class, this.timeFormatter, LocalTime::parse)).filter(Objects::nonNull).collect(Collectors.toList());
        List<TemporalFormatingRule> temporalFormatingRules = Stream.of(this.formatingRule(LocalDateTime.class, this.dateTimeFormatter), this.formatingRule(LocalDate.class, this.dateFormatter), this.formatingRule(LocalTime.class, this.timeFormatter)).filter(Objects::nonNull).collect(Collectors.toList());
        this.helper = DateTimeHelper.Builder.createDefault().addTemporalRecognitionRules(temporalRecognitionRules, true).addTemporalFormatingRules(temporalFormatingRules, true).build();
    }

    private DateTimeFormatter formatter(String pattern) {
        return cachedFormatters.computeIfAbsent(pattern, this::newFormatter);
    }

    private DateTimeFormatter newFormatter(String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            return null;
        }
        try {
            return new DateTimeFormatterBuilder().appendPattern(pattern).toFormatter(DateTimeConstants.DEFAULT_LOCALE);
        }
        catch (IllegalArgumentException ex) {
            logger.warn("failed to create date time formatter pattern '{}'", (Object)pattern, (Object)ex);
            return null;
        }
    }

    private <T extends TemporalAccessor> TemporalRecognitionRule<T> recognitionRule(Class<T> type, DateTimeFormatter formatter, BiFunction<CharSequence, DateTimeFormatter, T> parser) {
        return formatter != null ? TemporalRecognitionRule.of(type, formatter, parser) : null;
    }

    private TemporalFormatingRule formatingRule(Class<? extends TemporalAccessor> type, DateTimeFormatter formatter) {
        return formatter != null ? TemporalFormatingRule.of(type, formatter) : null;
    }
}

