/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson.config;

import com.jxdinfo.hussar.integration.support.jackson.config.JsonMultipartFileStrategy;
import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class JsonConfiguration {
    public static JsonConfiguration DEFAULT = JsonConfiguration.builder().build();
    public static JsonConfiguration COMPATIBLE = JsonConfiguration.builder().avoidBigNumber(true).eliminateNull(true).build();
    private final NavigableSet<Tag> tags;
    private final Boolean registerSpiModules;
    private final String dateTimeFormat;
    private final String dateFormat;
    private final String timeFormat;
    private final Boolean avoidBigNumber;
    private final Boolean eliminateNull;
    private final Boolean ambiguousQuote;
    private final Boolean propertyIgnoreCase;
    private final JsonMultipartFileStrategy multipartFileStrategy;

    private JsonConfiguration(NavigableSet<Tag> tags, Boolean registerSpiModules, String dateTimeFormat, String dateFormat, String timeFormat, Boolean avoidBigNumber, Boolean eliminateNull, Boolean ambiguousQuote, Boolean propertyIgnoreCase, JsonMultipartFileStrategy multipartFileStrategy) {
        this.tags = tags;
        this.registerSpiModules = registerSpiModules;
        this.dateTimeFormat = dateTimeFormat;
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
        this.avoidBigNumber = avoidBigNumber;
        this.eliminateNull = eliminateNull;
        this.ambiguousQuote = ambiguousQuote;
        this.propertyIgnoreCase = propertyIgnoreCase;
        this.multipartFileStrategy = multipartFileStrategy;
    }

    public static Builder builder() {
        return Builder.begin();
    }

    public Builder toBuilder() {
        return Builder.begin(this);
    }

    public NavigableSet<Tag> getTags() {
        return this.tags;
    }

    public Boolean getRegisterSpiModules() {
        return this.registerSpiModules;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public Boolean getAvoidBigNumber() {
        return this.avoidBigNumber;
    }

    public Boolean getEliminateNull() {
        return this.eliminateNull;
    }

    public Boolean getAmbiguousQuote() {
        return this.ambiguousQuote;
    }

    public Boolean getPropertyIgnoreCase() {
        return this.propertyIgnoreCase;
    }

    public JsonMultipartFileStrategy getMultipartFileStrategy() {
        return this.multipartFileStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonConfiguration that = (JsonConfiguration)o;
        return Objects.equals(this.tags, that.tags) && Objects.equals(this.registerSpiModules, that.registerSpiModules) && Objects.equals(this.dateTimeFormat, that.dateTimeFormat) && Objects.equals(this.dateFormat, that.dateFormat) && Objects.equals(this.timeFormat, that.timeFormat) && Objects.equals(this.avoidBigNumber, that.avoidBigNumber) && Objects.equals(this.eliminateNull, that.eliminateNull) && Objects.equals(this.ambiguousQuote, that.ambiguousQuote) && Objects.equals(this.propertyIgnoreCase, that.propertyIgnoreCase) && Objects.equals((Object)this.multipartFileStrategy, (Object)that.multipartFileStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.registerSpiModules, this.dateTimeFormat, this.dateFormat, this.timeFormat, this.avoidBigNumber, this.eliminateNull, this.ambiguousQuote, this.propertyIgnoreCase);
    }

    public String toString() {
        return "JsonConfiguration{tags=" + this.tags + ", registerSpiModules=" + this.registerSpiModules + ", dateTimeFormat='" + this.dateTimeFormat + '\'' + ", dateFormat='" + this.dateFormat + '\'' + ", timeFormat='" + this.timeFormat + '\'' + ", avoidBigNumber=" + this.avoidBigNumber + ", eliminateNull=" + this.eliminateNull + ", ambiguousQuote=" + this.ambiguousQuote + ", propertyIgnoreCase=" + this.propertyIgnoreCase + ", multipartFileStrategy=" + (Object)((Object)this.multipartFileStrategy) + '}';
    }

    public static final class Tag
    implements Comparable<Tag> {
        private static final Comparator<String> comparator = Comparator.nullsFirst(Comparator.naturalOrder());
        private final String name;
        private final String value;

        private Tag(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static Tag of(String name) {
            return Tag.of(name, null);
        }

        public static Tag of(String name, String value) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (StringUtils.containsAny((CharSequence)name, (char[])new char[]{':', ' '})) {
                throw new IllegalArgumentException();
            }
            return new Tag(name, value);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return Objects.equals(this.name, tag.name) && Objects.equals(this.value, tag.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        @Override
        public int compareTo(Tag other) {
            int cmp = comparator.compare(this.name, other.name);
            if (cmp != 0) {
                return cmp;
            }
            return comparator.compare(this.value, other.value);
        }

        public String toString() {
            if (this.value == null) {
                return this.name;
            }
            return this.name + ':' + this.value;
        }
    }

    public static final class Builder {
        private boolean tagsCopy;
        private NavigableSet<Tag> tags;
        private Boolean registerSpiModules;
        private String dateTimeFormat;
        private String dateFormat;
        private String timeFormat;
        private Boolean avoidBigNumber;
        private Boolean eliminateNull;
        private Boolean ambiguousQuote;
        private Boolean propertyIgnoreCase;
        private JsonMultipartFileStrategy multipartFileStrategy;

        public static Builder begin() {
            return new Builder();
        }

        public static Builder begin(JsonConfiguration configuration) {
            if (configuration == null) {
                return new Builder();
            }
            return new Builder().with(configuration);
        }

        private Builder with(JsonConfiguration configuration) {
            this.tagsCopy = true;
            this.tags = configuration.tags;
            this.registerSpiModules = configuration.registerSpiModules;
            this.dateTimeFormat = configuration.dateTimeFormat;
            this.dateFormat = configuration.dateFormat;
            this.timeFormat = configuration.timeFormat;
            this.avoidBigNumber = configuration.avoidBigNumber;
            this.eliminateNull = configuration.eliminateNull;
            this.ambiguousQuote = configuration.ambiguousQuote;
            this.propertyIgnoreCase = configuration.propertyIgnoreCase;
            this.multipartFileStrategy = configuration.multipartFileStrategy;
            return this;
        }

        public Builder tag(String name) {
            return this.tag(Tag.of(name));
        }

        public Builder tag(String name, String value) {
            return this.tag(Tag.of(name, value));
        }

        public Builder tag(Tag tag) {
            if (tag == null) {
                return this;
            }
            if (this.tagsCopy) {
                this.tagsCopy = false;
                this.tags = this.tags != null ? new TreeSet<Tag>((SortedSet<Tag>)this.tags) : new TreeSet();
            } else if (this.tags == null) {
                this.tags = new TreeSet<Tag>();
            }
            this.tags.add(tag);
            return this;
        }

        public Builder tags(NavigableSet<Tag> tags) {
            this.tagsCopy = false;
            this.tags = tags;
            return this;
        }

        public Builder registerSpiModules(Boolean registerSpiModules) {
            this.registerSpiModules = registerSpiModules;
            return this;
        }

        public Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder avoidBigNumber(Boolean avoidBigNumber) {
            this.avoidBigNumber = avoidBigNumber;
            return this;
        }

        public Builder eliminateNull(Boolean eliminateNull) {
            this.eliminateNull = eliminateNull;
            return this;
        }

        public Builder ambiguousQuote(Boolean ambiguousQuote) {
            this.ambiguousQuote = ambiguousQuote;
            return this;
        }

        public Builder propertyIgnoreCase(Boolean propertyIgnoreCase) {
            this.propertyIgnoreCase = propertyIgnoreCase;
            return this;
        }

        public Builder multipartFileStrategy(JsonMultipartFileStrategy multipartFileStrategy) {
            this.multipartFileStrategy = multipartFileStrategy;
            return this;
        }

        public JsonConfiguration build() {
            NavigableSet<Object> tags = this.tagsCopy ? (this.tags != null ? this.tags : Collections.emptyNavigableSet()) : (!CollectionUtils.isEmpty(this.tags) ? Collections.unmodifiableNavigableSet(this.tags) : Collections.emptyNavigableSet());
            return new JsonConfiguration(tags, this.registerSpiModules, this.dateTimeFormat, this.dateFormat, this.timeFormat, this.avoidBigNumber, this.eliminateNull, this.ambiguousQuote, this.propertyIgnoreCase, this.multipartFileStrategy);
        }
    }
}

