/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.jackson;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jxdinfo.hussar.integration.support.common.constants.DateTimeConstants;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationJsonException;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonConfiguration;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonConfigurationAware;
import com.jxdinfo.hussar.integration.support.jackson.datetime.ExtendedDateTimeModule;
import com.jxdinfo.hussar.integration.support.jackson.multipart.MultipartFileModule;
import com.jxdinfo.hussar.platform.core.serialize.HussarBeanSerializerModifier;
import com.jxdinfo.hussar.platform.core.serialize.HussarNumberModule;
import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class HussarIntegrationObjectMapper
extends ObjectMapper {
    protected static final Cache<JsonConfiguration, HussarIntegrationObjectMapper> instanceCache = CacheBuilder.newBuilder().initialCapacity(16).concurrencyLevel(4).maximumSize(200L).softValues().build();
    protected final JsonConfiguration configuration;

    protected HussarIntegrationObjectMapper() {
        this(JsonConfiguration.DEFAULT);
    }

    protected HussarIntegrationObjectMapper(JsonConfiguration configuration) {
        this.configuration = configuration != null ? configuration : JsonConfiguration.DEFAULT;
        this.initialize(this.configuration);
    }

    protected HussarIntegrationObjectMapper(HussarIntegrationObjectMapper objectMapper) {
        super((ObjectMapper)objectMapper);
        this.configuration = objectMapper.configuration;
    }

    protected void initialize(JsonConfiguration configuration) {
        this.initializeBasicSettings(configuration);
        this.initializeSpiModules(configuration);
        this.initializeExtraSettings(configuration);
    }

    protected void initializeBasicSettings(JsonConfiguration configuration) {
        SimpleDateFormat dateFormat;
        this.setLocale(DateTimeConstants.DEFAULT_LOCALE);
        this.setTimeZone(DateTimeConstants.DEFAULT_TIME_ZONE);
        String pattern = Optional.ofNullable(configuration).map(JsonConfiguration::getDateTimeFormat).orElse("yyyy-MM-dd HH:mm:ss");
        try {
            dateFormat = new SimpleDateFormat(pattern, DateTimeConstants.DEFAULT_LOCALE);
        }
        catch (IllegalArgumentException ex) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", DateTimeConstants.DEFAULT_LOCALE);
        }
        this.setDateFormat(dateFormat);
        boolean ambiguousQuote = Optional.ofNullable(configuration).map(JsonConfiguration::getAmbiguousQuote).orElse(true);
        boolean ignoreCase = Optional.ofNullable(configuration).map(JsonConfiguration::getPropertyIgnoreCase).orElse(false);
        this.configure(JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature(), ambiguousQuote);
        this.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        this.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, ignoreCase);
    }

    protected void initializeSpiModules(JsonConfiguration configuration) {
        boolean registerSpiModules = Optional.ofNullable(configuration).map(JsonConfiguration::getRegisterSpiModules).orElse(true);
        if (registerSpiModules) {
            this.findAndRegisterModules();
        }
    }

    protected void initializeExtraSettings(JsonConfiguration configuration) {
        boolean eliminateNull;
        this.registerModule((Module)new ExtendedDateTimeModule(configuration));
        boolean avoidBigNumber = Optional.ofNullable(configuration).map(JsonConfiguration::getAvoidBigNumber).orElse(false);
        if (avoidBigNumber) {
            this.registerModule((Module)new HussarNumberModule());
        }
        if (eliminateNull = Optional.ofNullable(configuration).map(JsonConfiguration::getEliminateNull).orElse(false).booleanValue()) {
            this.setSerializerFactory(this.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)new HussarBeanSerializerModifier()));
        }
        this.registerModule((Module)new MultipartFileModule(configuration));
    }

    public ObjectMapper registerModule(Module module) {
        if (module instanceof JsonConfigurationAware) {
            ((JsonConfigurationAware)module).setConfiguration(this.getConfiguration());
        }
        return super.registerModule(module);
    }

    public static HussarIntegrationObjectMapper createInstance() {
        return new HussarIntegrationObjectMapper();
    }

    public static HussarIntegrationObjectMapper createInstance(JsonConfiguration configuration) {
        JsonConfiguration key = configuration != null ? configuration : JsonConfiguration.DEFAULT;
        try {
            return (HussarIntegrationObjectMapper)((Object)instanceCache.get((Object)key, () -> new HussarIntegrationObjectMapper(key)));
        }
        catch (ExecutionException ex) {
            throw new HussarIntegrationJsonException("BaseObjectMapper instance cache item computation failure", ex.getCause());
        }
    }

    public HussarIntegrationObjectMapper copy() {
        this._checkInvalidCopy(HussarIntegrationObjectMapper.class);
        return new HussarIntegrationObjectMapper(this);
    }

    public JsonConfiguration getConfiguration() {
        return this.configuration;
    }
}

