/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.extra;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ReferenceConverter<T>
extends AbstractBaseTypeConverter<Reference<?>> {
    private final Set<Class<?>> TARGET_CLASSES = this.getReferenceClasses();

    @Override
    public boolean isTargetClassesExhaustive() {
        return true;
    }

    @Override
    public Set<Class<?>> getTargetClasses() {
        return this.TARGET_CLASSES;
    }

    @Override
    public Reference<?> convert(ConvertContext context, Object value, Type type) {
        Class<Reference<?>> clazz = this.getRawTargetClass(type);
        Type innerType = this.getReferenceInnerType(type);
        if (value != null && Reference.class.isAssignableFrom(value.getClass())) {
            value = ((Reference)value).get();
        }
        Object converted = value != null ? context.convert(value, innerType) : null;
        return this.createReference(converted, clazz);
    }

    @Override
    protected Class<? extends Reference<?>> getRawTargetClass(Type type) {
        Class<?> rawTargetClass = super.getRawTargetClass(type);
        if (rawTargetClass == null || !Reference.class.isAssignableFrom(rawTargetClass)) {
            throw new HussarIntegrationConvertException("Reference<T> converter do not support target type: " + rawTargetClass);
        }
        return rawTargetClass;
    }

    private Type getReferenceInnerType(Type type) {
        if (type instanceof Class) {
            if (!this.TARGET_CLASSES.contains((Class)type)) {
                throw new HussarIntegrationConvertException("Reference<T> converter do not support target type: " + type);
            }
            return Object.class;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!this.TARGET_CLASSES.contains((Class)parameterizedType.getRawType())) {
                throw new HussarIntegrationConvertException("Reference<T> converter do not support target type: " + type);
            }
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            return typeArguments[0];
        }
        throw new HussarIntegrationConvertException("unsupported reflect type for Reference<T> converter: " + type);
    }

    protected Reference<?> createReference(Object value, Class<? extends Reference<?>> clazz) {
        if (Objects.equals(clazz, WeakReference.class)) {
            return new WeakReference<Object>(value);
        }
        if (Objects.equals(clazz, SoftReference.class)) {
            return new SoftReference<Object>(value);
        }
        throw new HussarIntegrationConvertException("Reference<T> converter do not support target type: " + clazz);
    }

    protected Set<Class<?>> getReferenceClasses() {
        return Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(WeakReference.class, SoftReference.class)));
    }
}

