/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.extra;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.IOUtils;

public class PatternConverter
extends AbstractBaseTypeConverter<Pattern> {
    @Override
    public Pattern convert(ConvertContext context, Object value, Type type) {
        if (!this.accepts(context, type)) {
            throw new HussarIntegrationConvertException("bytes converter do not support target type: " + type);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Matcher) {
            return ((Matcher)value).pattern();
        }
        if (value instanceof String) {
            return this.compile((String)value);
        }
        if (value instanceof byte[]) {
            return this.compile(new String((byte[])value, StandardCharsets.UTF_8));
        }
        if (value instanceof CharSequence) {
            return this.compile(value.toString());
        }
        if (value instanceof Character) {
            return this.compile(String.valueOf(((Character)value).charValue()));
        }
        if (value instanceof Blob) {
            String pattern;
            try {
                pattern = IOUtils.toString((InputStream)((Blob)value).getBinaryStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | SQLException ex) {
                throw new HussarIntegrationConvertException("blob to regexp pattern string conversion failed", ex);
            }
            return this.compile(pattern);
        }
        if (value instanceof Clob) {
            String pattern;
            try {
                pattern = IOUtils.toString((Reader)((Clob)value).getCharacterStream());
            }
            catch (IOException | SQLException ex) {
                throw new HussarIntegrationConvertException("blob to regexp pattern string conversion failed", ex);
            }
            return this.compile(pattern);
        }
        throw new HussarIntegrationConvertException("cannot convert regexp pattern from: " + value.getClass());
    }

    protected final Pattern compile(String pattern) {
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException ex) {
            throw new HussarIntegrationConvertException("regexp pattern conversion or compilation failed", ex);
        }
    }
}

