/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.extra;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class OptionalConverter<T>
extends AbstractBaseTypeConverter<Optional<?>> {
    @Override
    public Optional<?> convert(ConvertContext context, Object value, Type type) {
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof Optional) {
            value = ((Optional)value).orElse(null);
        }
        Type innerType = this.getOptionalInnerType(type);
        Object converted = context.convert(value, innerType);
        return Optional.ofNullable(converted);
    }

    private Type getOptionalInnerType(Type type) {
        if (type instanceof Class) {
            if (type != Optional.class) {
                throw new HussarIntegrationConvertException("Optional<T> converter do not support target type: " + type);
            }
            return Object.class;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType() != Optional.class) {
                throw new HussarIntegrationConvertException("Optional<T> converter do not support target type: " + type);
            }
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            return typeArguments[0];
        }
        throw new HussarIntegrationConvertException("unsupported reflect type for Optional<T> converter: " + type);
    }
}

