/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.extra;

import com.jxdinfo.hussar.integration.support.common.multipart.ByteArrayMultipartFile;
import com.jxdinfo.hussar.integration.support.common.multipart.LocalFileMultipartFile;
import com.jxdinfo.hussar.integration.support.common.multipart.RequestPartMultipartFile;
import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationEntityException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationEntityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileConverter
extends AbstractBaseTypeConverter<MultipartFile> {
    private final Set<Class<?>> TARGET_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(MultipartFile.class, ByteArrayMultipartFile.class)));

    @Override
    public boolean isTargetClassesExhaustive() {
        return true;
    }

    @Override
    public Set<Class<?>> getTargetClasses() {
        return this.TARGET_CLASSES;
    }

    @Override
    public MultipartFile convert(ConvertContext context, Object value, Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        if (!this.TARGET_CLASSES.contains(clazz)) {
            throw new HussarIntegrationConvertException("MultipartFile converter do not support target type: " + type);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof MultipartFile) {
            if (clazz.isAssignableFrom(value.getClass())) {
                return (MultipartFile)value;
            }
            if (clazz.isAssignableFrom(ByteArrayMultipartFile.class)) {
                try {
                    return ByteArrayMultipartFile.of((MultipartFile)value);
                }
                catch (Exception ex) {
                    throw new HussarIntegrationConvertException("failed to convert to ByteArrayMultipartFile", ex);
                }
            }
            throw new HussarIntegrationConvertException("MultipartFile converter do not support target type: " + clazz);
        }
        if (value instanceof byte[]) {
            return this.createFromBytes(clazz, "<unknown>", "application/octet-stream", "data.bin", (byte[])value);
        }
        if (value instanceof CharSequence) {
            byte[] bytes = value.toString().getBytes(StandardCharsets.UTF_8);
            return this.createFromBytes(clazz, "<unknown>", "text/plain", "data.txt", bytes);
        }
        if (value instanceof File) {
            return this.createFromFile(clazz, "<unknown>", (File)value);
        }
        if (value instanceof Path) {
            return this.createFromFile(clazz, "<unknown>", ((Path)value).toFile());
        }
        if (value instanceof Part) {
            return this.createFromPart(clazz, (Part)value);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            String name = (String)context.convert(map.get("name"), (Type)((Object)String.class));
            String contentType = (String)context.convert(map.get("contentType"), (Type)((Object)String.class));
            String originalFilename = (String)context.convert(map.get("originalFilename"), (Type)((Object)String.class));
            byte[] bytes = (byte[])context.convert(map.get("bytes"), (Type)((Object)byte[].class));
            return this.createFromBytes(clazz, name, contentType, originalFilename, bytes);
        }
        if (this.getEntityUtilsBean(context).isProbablyEntity(value.getClass())) {
            String name = null;
            String contentType = null;
            String originalFilename = null;
            byte[] bytes = null;
            HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = this.getEntityUtilsBean(context);
            Map<String, HussarIntegrationEntityUtils.EntityPropertyDescriptor> properties = entityUtils.getReadableProperties(value.getClass());
            Iterator<String> iterator = properties.keySet().iterator();
            block29: while (iterator.hasNext()) {
                Object propertyValue;
                String propertyName;
                switch (propertyName = iterator.next()) {
                    case "name": 
                    case "contentType": 
                    case "originalFilename": 
                    case "bytes": {
                        break;
                    }
                    default: {
                        continue block29;
                    }
                }
                try {
                    propertyValue = entityUtils.getProperty(value, propertyName, true);
                }
                catch (HussarIntegrationEntityException ex) {
                    throw new HussarIntegrationConvertException("MultipartFile converter failed to get pojo property: " + propertyName, (Throwable)((Object)ex));
                }
                switch (propertyName) {
                    case "name": {
                        name = (String)context.convert(propertyValue, (Type)((Object)String.class));
                        break;
                    }
                    case "contentType": {
                        contentType = (String)context.convert(propertyValue, (Type)((Object)String.class));
                        break;
                    }
                    case "originalFilename": {
                        originalFilename = (String)context.convert(propertyValue, (Type)((Object)String.class));
                        break;
                    }
                    case "bytes": {
                        bytes = (byte[])context.convert(propertyValue, (Type)((Object)byte[].class));
                    }
                }
            }
            return this.createFromBytes(clazz, name, contentType, originalFilename, bytes);
        }
        if (value instanceof Character) {
            byte[] bytes = String.valueOf(((Character)value).charValue()).getBytes(StandardCharsets.UTF_8);
            return this.createFromBytes(clazz, "<unknown>", "text/plain", "data.txt", bytes);
        }
        if (value instanceof Blob) {
            byte[] bytes;
            try {
                bytes = IOUtils.toByteArray((InputStream)((Blob)value).getBinaryStream());
            }
            catch (IOException | SQLException ex) {
                throw new HussarIntegrationConvertException("blob to string conversion failed", ex);
            }
            return this.createFromBytes(clazz, "<unknown>", "application/octet-stream", "data.bin", bytes);
        }
        if (value instanceof Clob) {
            byte[] bytes;
            try {
                bytes = IOUtils.toByteArray((Reader)((Clob)value).getCharacterStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | SQLException ex) {
                throw new HussarIntegrationConvertException("blob to string conversion failed", ex);
            }
            return this.createFromBytes(clazz, "<unknown>", "text/plain", "data.txt", bytes);
        }
        throw new HussarIntegrationConvertException("MultipartFile converter cannot convert value");
    }

    private HussarIntegrationEntityUtils.EntityUtilsBean getEntityUtilsBean(ConvertContext context) {
        return context.getCachedBean(HussarIntegrationEntityUtils.EntityUtilsBean.class, HussarIntegrationEntityUtils::createUtilsBean);
    }

    private ByteArrayMultipartFile createFromBytes(Class<?> target, String name, String contentType, String originalFilename, byte[] bytes) {
        if (name == null && contentType == null && originalFilename == null && bytes == null) {
            return null;
        }
        if (bytes == null) {
            throw new HussarIntegrationConvertException("ByteArrayMultipartFile missing non-null 'bytes'");
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = "<unknown>";
        }
        if (target.isAssignableFrom(ByteArrayMultipartFile.class)) {
            try {
                return ByteArrayMultipartFile.of(name, contentType, originalFilename, bytes);
            }
            catch (Exception ex) {
                throw new HussarIntegrationConvertException("failed to construct ByteArrayMultipartFile", ex);
            }
        }
        throw new HussarIntegrationConvertException("MultipartFile converter do not support target type: " + target);
    }

    private LocalFileMultipartFile createFromFile(Class<?> target, String name, File file) {
        if (file == null) {
            throw new HussarIntegrationConvertException("LocalFileMultipartFile missing non-null 'file'");
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = "<unknown>";
        }
        if (target.isAssignableFrom(LocalFileMultipartFile.class)) {
            try {
                return LocalFileMultipartFile.of(name, file);
            }
            catch (Exception ex) {
                throw new HussarIntegrationConvertException("failed to construct LocalFileMultipartFile", ex);
            }
        }
        throw new HussarIntegrationConvertException("MultipartFile converter do not support target type: " + target);
    }

    private RequestPartMultipartFile createFromPart(Class<?> target, Part part) {
        if (part == null) {
            throw new HussarIntegrationConvertException("RequestPartMultipartFile missing non-null 'part'");
        }
        if (target.isAssignableFrom(RequestPartMultipartFile.class)) {
            try {
                return RequestPartMultipartFile.of(part);
            }
            catch (Exception ex) {
                throw new HussarIntegrationConvertException("failed to construct RequestPartMultipartFile", ex);
            }
        }
        throw new HussarIntegrationConvertException("MultipartFile converter do not support target type: " + target);
    }
}

