/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.extra;

import com.jxdinfo.hussar.integration.support.common.formdata.AbstractFormData;
import com.jxdinfo.hussar.integration.support.common.formdata.FormData;
import com.jxdinfo.hussar.integration.support.common.formdata.MultipartFormData;
import com.jxdinfo.hussar.integration.support.common.formdata.UrlEncodedFormData;
import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationEntityException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationEntityUtils;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FormDataConverter
extends AbstractBaseTypeConverter<FormData> {
    private final Set<Class<?>> TARGET_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(FormData.class, MultipartFormData.class, UrlEncodedFormData.class)));

    @Override
    public boolean isTargetClassesExhaustive() {
        return true;
    }

    @Override
    public Set<Class<?>> getTargetClasses() {
        return this.TARGET_CLASSES;
    }

    @Override
    public FormData convert(ConvertContext context, Object value, Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        if (!this.TARGET_CLASSES.contains(clazz)) {
            throw new HussarIntegrationConvertException("FormData converter do not support target type: " + type);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof FormData) {
            AbstractFormData target;
            FormData source = (FormData)value;
            if (clazz.isAssignableFrom(value.getClass())) {
                return source;
            }
            if (clazz.equals(UrlEncodedFormData.class)) {
                target = new UrlEncodedFormData();
            } else {
                target = new MultipartFormData();
                if (source instanceof MultipartFormData && ((MultipartFormData)source).isExplicitBoundary()) {
                    ((MultipartFormData)target).setBoundary(((MultipartFormData)source).getBoundary());
                }
            }
            for (Map.Entry<String, Object> entry : source.entries()) {
                try {
                    target.append(entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException ex) {
                    String itemClass = entry.getValue() != null ? entry.getValue().getClass().getName() : "null";
                    throw new HussarIntegrationConvertException("FormData converter for '" + clazz.getSimpleName() + "' do not support form item value: " + itemClass, ex);
                }
            }
            return target;
        }
        if (value instanceof Map) {
            AbstractFormData form = clazz.equals(UrlEncodedFormData.class) ? new UrlEncodedFormData() : new MultipartFormData();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String name = (String)context.convert(entry.getKey(), (Type)((Object)String.class));
                if (name == null) continue;
                Object val = entry.getValue();
                try {
                    if (val instanceof Collection) {
                        form.appendAll(name, (Collection)val);
                        continue;
                    }
                    form.append(name, val);
                }
                catch (IllegalArgumentException ex) {
                    String itemClass = val != null ? val.getClass().getName() : "null";
                    throw new HussarIntegrationConvertException("FormData converter for '" + clazz.getSimpleName() + "' do not support form item value: " + itemClass, ex);
                }
            }
            return form;
        }
        if (this.getEntityUtilsBean(context).isProbablyEntity(value.getClass())) {
            AbstractFormData form = clazz.equals(UrlEncodedFormData.class) ? new UrlEncodedFormData() : new MultipartFormData();
            HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = this.getEntityUtilsBean(context);
            Map<String, HussarIntegrationEntityUtils.EntityPropertyDescriptor> properties = entityUtils.getReadableProperties(value.getClass());
            for (String propertyName : properties.keySet()) {
                Object propertyValue;
                try {
                    propertyValue = entityUtils.getProperty(value, propertyName, true);
                }
                catch (HussarIntegrationEntityException ex) {
                    throw new HussarIntegrationConvertException("FormData converter failed to get pojo property: " + propertyName, (Throwable)((Object)ex));
                }
                try {
                    if (propertyValue instanceof Collection) {
                        form.appendAll(propertyName, (Collection)propertyValue);
                        continue;
                    }
                    form.append(propertyName, propertyValue);
                }
                catch (IllegalArgumentException ex) {
                    String itemClass = propertyValue != null ? propertyValue.getClass().getName() : "null";
                    throw new HussarIntegrationConvertException("FormData converter for '" + clazz.getSimpleName() + "' do not support form item value: " + itemClass, ex);
                }
            }
            return form;
        }
        throw new HussarIntegrationConvertException("FormData converter cannot convert value");
    }

    private HussarIntegrationEntityUtils.EntityUtilsBean getEntityUtilsBean(ConvertContext context) {
        return context.getCachedBean(HussarIntegrationEntityUtils.EntityUtilsBean.class, HussarIntegrationEntityUtils::createUtilsBean);
    }
}

