/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.extra;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.reflect.TypeUtils;

public class FastJsonConverter
extends AbstractBaseTypeConverter<JSON> {
    private final Set<Class<?>> TARGET_CLASSES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(JSON.class, JSONArray.class, JSONObject.class)));

    @Override
    public boolean isTargetClassesExhaustive() {
        return true;
    }

    @Override
    public Set<Class<?>> getTargetClasses() {
        return this.TARGET_CLASSES;
    }

    @Override
    public JSON convert(ConvertContext context, Object value, Type type) {
        Object json;
        Class<?> clazz = this.getRawTargetClass(type);
        if (!this.TARGET_CLASSES.contains(clazz)) {
            throw new HussarIntegrationConvertException("FastJSON converter do not support target type: " + type);
        }
        if (value == null) {
            return null;
        }
        if (this.TARGET_CLASSES.contains(value.getClass()) && context.getFeature("reuse.aggressive") && this.isProbablyReusable(value, type)) {
            return (JSON)value;
        }
        if (value instanceof CharSequence || value instanceof byte[]) {
            ParserConfig config = context.getCachedBean(ParserConfig.class, ParserConfig::new);
            json = value instanceof String ? JSON.parse((String)((String)value), (ParserConfig)config, (int)JSON.DEFAULT_PARSER_FEATURE) : (value instanceof CharSequence ? JSON.parse((String)value.toString(), (ParserConfig)config, (int)JSON.DEFAULT_PARSER_FEATURE) : JSON.parse((String)new String((byte[])value, StandardCharsets.UTF_8), (ParserConfig)config, (int)JSON.DEFAULT_PARSER_FEATURE));
        } else {
            SerializeConfig config = context.getCachedBean(SerializeConfig.class, SerializeConfig::new);
            json = JSON.toJSON((Object)value, (SerializeConfig)config);
        }
        if (json instanceof JSONArray) {
            if (clazz == JSONObject.class) {
                throw new HussarIntegrationConvertException("FastJSON converter cannot convert value to JSONObject");
            }
            return (JSONArray)json;
        }
        if (json instanceof JSONObject) {
            if (clazz == JSONArray.class) {
                throw new HussarIntegrationConvertException("FastJSON converter cannot convert value to JSONArray");
            }
            return (JSONObject)json;
        }
        throw new HussarIntegrationConvertException("FastJSON converter cannot convert value to JSONArray or JSONObject");
    }

    private boolean isProbablyReusable(Object value, Type type) {
        Class sourceClass = Optional.ofNullable(value).map(Object::getClass).orElse(null);
        Class targetClass = TypeUtils.getRawType((Type)type, null);
        return sourceClass == null || targetClass == null || targetClass.isAssignableFrom(sourceClass);
    }
}

