/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TemporalConverter
extends AbstractBaseTypeConverter<TemporalAccessor> {
    private static final Set<Class<?>> TARGET_CLASSES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Instant.class, LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, LocalDate.class, LocalTime.class, OffsetTime.class)));

    @Override
    public boolean isTargetClassesExhaustive() {
        return true;
    }

    @Override
    public Set<Class<?>> getTargetClasses() {
        return TARGET_CLASSES;
    }

    @Override
    public TemporalAccessor convert(ConvertContext context, Object value, Type type) {
        Class<? extends TemporalAccessor> clazz = this.getCheckedTemporalAccessorClass(type);
        DateTimeHelper helper = this.getDateTimeHelper(context);
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            String literal = ((CharSequence)value).toString();
            if (StringUtils.isEmpty((CharSequence)literal)) {
                return null;
            }
            TemporalAccessor temporal = helper.convert(helper.toTemporalAccessor(literal), clazz);
            if (temporal == null) {
                throw new HussarIntegrationConvertException("cannot parse temporal type '" + clazz + "' from: " + value);
            }
            return temporal;
        }
        if (value instanceof Number) {
            TemporalAccessor temporal;
            if (value instanceof Double || value instanceof Float) {
                double floating;
                double d = floating = value instanceof Double ? (Double)value : (double)((Float)value).floatValue();
                if (!Double.isFinite(floating)) {
                    return null;
                }
            }
            if ((temporal = helper.convert(helper.toInstant(((Number)value).longValue()), clazz)) == null) {
                throw new HussarIntegrationConvertException("cannot retrieve temporal type '" + clazz + "' from timestamp: " + value);
            }
            return temporal;
        }
        if (value instanceof TemporalAccessor) {
            TemporalAccessor temporal = helper.convert((TemporalAccessor)value, clazz);
            if (temporal == null) {
                throw new HussarIntegrationConvertException("cannot convert temporal type '" + clazz + "' from another temporal: " + value);
            }
            return temporal;
        }
        if (value instanceof Date) {
            TemporalAccessor temporal = helper.convert(helper.toLocalDateTime((Date)value), clazz);
            if (temporal == null) {
                throw new HussarIntegrationConvertException("cannot convert temporal type '" + clazz + "' from date: " + value);
            }
            return temporal;
        }
        throw new HussarIntegrationConvertException("cannot convert temporal type '" + clazz + "' from: " + value.getClass());
    }

    private Class<? extends TemporalAccessor> getCheckedTemporalAccessorClass(Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        if (!TARGET_CLASSES.contains(clazz)) {
            throw new HussarIntegrationConvertException("temporal converter do not support target type: " + type);
        }
        return clazz;
    }

    private DateTimeHelper getDateTimeHelper(ConvertContext context) {
        return context.getCachedBean(DateTimeHelper.class, () -> DateTimeHelper.DEFAULT);
    }
}

