/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public class StringConverter
extends AbstractBaseTypeConverter<String> {
    @Override
    public String convert(ConvertContext context, Object value, Type type) {
        if (!this.accepts(context, type)) {
            throw new HussarIntegrationConvertException("string converter do not support target type: " + type);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Character) {
            return String.valueOf(((Character)value).charValue());
        }
        if (value.getClass().isArray()) {
            return this.convertArrayToString(value);
        }
        if (value instanceof Date) {
            LocalDateTime datetime;
            DateTimeHelper helper = this.getDateTimeHelper(context);
            String string = helper.toString(datetime = helper.toLocalDateTime((Date)value));
            if (string == null) {
                throw new HussarIntegrationConvertException("date to string conversion failed");
            }
            return string;
        }
        if (value instanceof TemporalAccessor) {
            String string = this.getDateTimeHelper(context).toString((TemporalAccessor)value);
            if (string == null) {
                throw new HussarIntegrationConvertException("temporal to string conversion failed");
            }
            return string;
        }
        if (value instanceof Blob) {
            try {
                return IOUtils.toString((InputStream)((Blob)value).getBinaryStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | SQLException ex) {
                throw new HussarIntegrationConvertException("blob to string conversion failed", ex);
            }
        }
        if (value instanceof Clob) {
            try {
                return IOUtils.toString((Reader)((Clob)value).getCharacterStream());
            }
            catch (IOException | SQLException ex) {
                throw new HussarIntegrationConvertException("blob to string conversion failed", ex);
            }
        }
        return value.toString();
    }

    private String convertArrayToString(Object array) {
        if (array == null) {
            return null;
        }
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof byte[]) {
            return new String((byte[])array, StandardCharsets.UTF_8);
        }
        if (array instanceof char[]) {
            return new String((char[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof float[]) {
            return Arrays.toString((float[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (array instanceof Object[]) {
            return Arrays.toString((Object[])array);
        }
        throw new HussarIntegrationConvertException("array to string converter input is not array: " + array.getClass());
    }

    private DateTimeHelper getDateTimeHelper(ConvertContext context) {
        return context.getCachedBean(DateTimeHelper.class, () -> DateTimeHelper.DEFAULT);
    }
}

