/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.common.formdata.FormData;
import com.jxdinfo.hussar.integration.support.common.formdata.utils.InternalFormDataUtils;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.convert.Converter;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationEntityException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationEntityUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationGenericsUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public class PojoConverter
implements Converter {
    private static final int DEFAULT_CACHE_CAPACITY = 16;
    private final ConcurrentMap<String, Map<String, PojoPropertySetter>> cache;

    public PojoConverter() {
        this(false);
    }

    public PojoConverter(boolean oneshot) {
        this.cache = new ConcurrentReferenceHashMap(16, oneshot ? ConcurrentReferenceHashMap.ReferenceType.WEAK : ConcurrentReferenceHashMap.ReferenceType.SOFT);
    }

    @Override
    public boolean accepts(ConvertContext context, Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        return this.getEntityUtils(context).isProbablyConstructableEntity(clazz);
    }

    @Override
    public <T> T convert(ConvertContext context, Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (context.getFeature("reuse.aggressive") && this.isProbablyReusable(context, value, type)) {
            return (T)value;
        }
        Class<?> targetClass = this.getRawTargetClass(type);
        if (!this.getEntityUtils(context).isProbablyConstructableEntity(targetClass)) {
            throw new HussarIntegrationConvertException("POJO converter do not support target type: " + type);
        }
        Map<String, PojoPropertySetter> properties = this.getPojoProperties(context, type);
        Map<String, Object> map = this.parseValue(context, properties, value);
        Object pojo = this.createPojo(context, targetClass, properties, map);
        return (T)pojo;
    }

    protected boolean isProbablyReusable(ConvertContext context, Object value, Type type) {
        Class<?> sourceClass = value.getClass();
        HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = this.getEntityUtils(context);
        if (sourceClass != null && !entityUtils.isProbablyEntity(sourceClass)) {
            return false;
        }
        Class targetClass = TypeUtils.getRawType((Type)type, null);
        if (sourceClass != null && targetClass != null && !targetClass.isAssignableFrom(sourceClass)) {
            return false;
        }
        Map<String, PojoPropertySetter> targetProperties = this.getPojoProperties(context, type);
        for (String propertyName : entityUtils.getReadableProperties(sourceClass).keySet()) {
            Class sourcePropertyClass = Optional.ofNullable(entityUtils.getProperty(value, propertyName, false)).map(Object::getClass).orElse(null);
            Class targetPropertyClass = Optional.ofNullable(targetProperties.get(propertyName)).map(PojoPropertySetter::getType).map(ty -> TypeUtils.getRawType((Type)ty, null)).orElse(null);
            if (sourcePropertyClass == null || targetPropertyClass == null || targetPropertyClass.isAssignableFrom(sourcePropertyClass)) continue;
            return false;
        }
        return true;
    }

    protected Map<String, Object> parseValue(ConvertContext context, Map<String, PojoPropertySetter> properties, Object value) {
        LinkedHashMap<String, Object> map;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = context.getCachedBean(HussarIntegrationJsonUtils.JsonUtilsBean.class, HussarIntegrationJsonUtils::createUtilsBean);
            try {
                return jsonUtils.parse((String)value, new TypeReference<Map<String, Object>>(){});
            }
            catch (Exception ex) {
                throw new HussarIntegrationConvertException("failed to parse json string", ex);
            }
        }
        if (value instanceof byte[]) {
            HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = context.getCachedBean(HussarIntegrationJsonUtils.JsonUtilsBean.class, HussarIntegrationJsonUtils::createUtilsBean);
            try {
                return jsonUtils.parse((byte[])value, new TypeReference<Map<String, Object>>(){});
            }
            catch (Exception ex) {
                throw new HussarIntegrationConvertException("failed to parse json bytes", ex);
            }
        }
        if (value instanceof Map) {
            map = new LinkedHashMap<String, Object>();
            Map source = (Map)value;
            for (String property : properties.keySet()) {
                if (!source.containsKey(property)) continue;
                map.put(property, source.get(property));
            }
        } else if (value instanceof FormData) {
            FormData form = (FormData)value;
            map = new LinkedHashMap();
            for (String key : form.keys()) {
                Object convertedValue;
                PojoPropertySetter property = properties.get(key);
                if (property == null) continue;
                Type valueType = (Type)((Object)Optional.ofNullable(property.getType()).orElse((Type)((Object)Object.class)));
                List<Object> values = form.getAll(key);
                if (values.isEmpty()) continue;
                if (values.size() == 1 && InternalFormDataUtils.guessShouldUnwrapFormElement(values, valueType) != Boolean.FALSE) {
                    Object element = values.get(0);
                    convertedValue = context.convert(element, valueType);
                } else {
                    convertedValue = context.convert(values, valueType);
                }
                map.put(key, convertedValue);
            }
        } else if (this.getEntityUtils(context).isProbablyEntity(value.getClass())) {
            map = new LinkedHashMap();
            HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = this.getEntityUtils(context);
            for (String name : entityUtils.getReadableProperties(value.getClass()).keySet()) {
                Object property;
                try {
                    property = entityUtils.getProperty(value, name, true);
                }
                catch (HussarIntegrationEntityException ex) {
                    throw new HussarIntegrationConvertException("POJO converter failed to get source pojo property: " + name, (Throwable)((Object)ex));
                }
                map.put(name, property);
            }
        } else {
            throw new HussarIntegrationConvertException("POJO converter cannot convert from source type: " + value.getClass());
        }
        return map;
    }

    protected Object createPojo(ConvertContext context, Class<?> clazz, Map<String, PojoPropertySetter> properties, Map<String, Object> map) {
        Object pojo;
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            pojo = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new HussarIntegrationConvertException("POJO converter cannot create pojo instance: " + clazz, ex);
        }
        try {
            for (PojoPropertySetter propertySetter : properties.values()) {
                Object value = map.get(propertySetter.getName());
                propertySetter.invoke(context, pojo, value);
            }
        }
        catch (HussarIntegrationEntityException ex) {
            throw new HussarIntegrationConvertException("POJO converter cannot initialize pojo: " + clazz, (Throwable)((Object)ex));
        }
        return pojo;
    }

    private Map<String, PojoPropertySetter> getPojoProperties(ConvertContext context, Type type) {
        return this.cache.computeIfAbsent(type.getTypeName(), typeName -> this.computePojoProperties(context, type));
    }

    private Map<String, PojoPropertySetter> computePojoProperties(ConvertContext context, Type type) {
        LinkedHashMap<String, PojoPropertySetter> properties = new LinkedHashMap<String, PojoPropertySetter>();
        HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = this.getEntityUtils(context);
        HussarIntegrationGenericsUtils.GenericsUtilsBean genericsUtils = this.getGenericsUtils(context);
        Class<?> clazz = this.getRawTargetClass(type);
        Type[] arguments = this.getTargetClassParameters(type);
        for (HussarIntegrationEntityUtils.EntityPropertyDescriptor descriptor : entityUtils.getWritableProperties(clazz).values()) {
            Type propertyType;
            String propertyName = descriptor.getName();
            HussarIntegrationEntityUtils.EntityMemberAccessor writeAccessor = descriptor.getWriteAccessor();
            if (writeAccessor == null) continue;
            if (writeAccessor instanceof HussarIntegrationEntityUtils.EntityPropertyAccessor) {
                Method setterMethod = ((HussarIntegrationEntityUtils.EntityPropertyAccessor)writeAccessor).getAccessor();
                propertyType = genericsUtils.resolveSetterType(setterMethod, clazz, arguments);
            } else {
                if (!(writeAccessor instanceof HussarIntegrationEntityUtils.EntityFieldAccessor)) continue;
                Field field = ((HussarIntegrationEntityUtils.EntityFieldAccessor)writeAccessor).getAccessor();
                propertyType = genericsUtils.resolveFieldType(field, clazz, arguments);
            }
            PojoPropertySetter pojoPropertySetter = new PojoPropertySetter(propertyName, propertyType, writeAccessor);
            properties.put(propertyName, pojoPropertySetter);
        }
        return properties;
    }

    private HussarIntegrationEntityUtils.EntityUtilsBean getEntityUtils(ConvertContext context) {
        return context.getCachedBean(HussarIntegrationEntityUtils.EntityUtilsBean.class, HussarIntegrationEntityUtils::createUtilsBean);
    }

    private HussarIntegrationGenericsUtils.GenericsUtilsBean getGenericsUtils(ConvertContext context) {
        return context.getCachedBean(HussarIntegrationGenericsUtils.GenericsUtilsBean.class, HussarIntegrationGenericsUtils::createUtilsBean);
    }

    private Class<?> getRawTargetClass(Type type) {
        Class clazz;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = (Class)parameterizedType.getRawType();
        } else {
            clazz = null;
        }
        return clazz;
    }

    private Type[] getTargetClassParameters(Type type) {
        if (type instanceof Class) {
            return new Type[0];
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments();
        }
        return null;
    }

    protected static final class PojoPropertySetter {
        private final String name;
        private final Type type;
        private final HussarIntegrationEntityUtils.EntityMemberAccessor accessor;

        public PojoPropertySetter(String name, Type type, HussarIntegrationEntityUtils.EntityMemberAccessor accessor) {
            this.name = name;
            this.type = type;
            this.accessor = accessor;
        }

        public void invoke(ConvertContext context, Object pojo, Object value) {
            Object converted = context.convert(value, this.type);
            this.accessor.write(pojo, converted);
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public HussarIntegrationEntityUtils.EntityMemberAccessor getAccessor() {
            return this.accessor;
        }
    }
}

