/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.StringUtils;

public class NumberConverter
extends AbstractBaseTypeConverter<Number> {
    private final Map<Class<?>, NumberTypeInfo> TARGET_CLASS_INFOS = this.getNumberTypeInfos();
    private static final ByteOrder DEFAULT_ENDIAN = ByteOrder.BIG_ENDIAN;
    private static final long MIN_FLOATING_SAFE_INTEGRAL = -9007199254740991L;
    private static final long MAX_FLOATING_SAFE_INTEGRAL = 0x1FFFFFFFFFFFFFL;

    @Override
    public boolean isTargetClassesExhaustive() {
        return true;
    }

    @Override
    public Set<Class<?>> getTargetClasses() {
        return this.TARGET_CLASS_INFOS.keySet();
    }

    @Override
    public Number convert(ConvertContext context, Object value, Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        NumberTypeInfo info = this.TARGET_CLASS_INFOS.get(clazz);
        if (info == null) {
            throw new HussarIntegrationConvertException("number converter do not support target type: " + type);
        }
        if (value == null && !clazz.isPrimitive()) {
            return null;
        }
        NumberCategory category = info.getCategory();
        switch (category) {
            case INTEGRAL: {
                return this.fromIntegral(this.toIntegral(context, value, clazz), clazz);
            }
            case FLOATING: {
                return this.fromFloating(this.toFloating(context, value, clazz), clazz);
            }
            case DECIMAL: {
                return this.fromDecimal(this.toDecimal(context, value, clazz), clazz);
            }
        }
        throw new HussarIntegrationConvertException("unsupported number category: " + (Object)((Object)category));
    }

    private BigInteger toIntegral(ConvertContext context, Object value, Class<?> clazz) {
        if (value == null) {
            return BigInteger.ZERO;
        }
        if (value instanceof Number) {
            return this.toIntegral((Number)value, clazz);
        }
        if (value instanceof Boolean) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (value instanceof Character) {
            return BigInteger.valueOf(((Character)value).charValue());
        }
        if (value instanceof CharSequence) {
            String literal = ((CharSequence)value).toString();
            Number parsed = this.parseNumber(literal, clazz);
            return this.toIntegral(parsed, clazz);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            Number parsed = this.parseNumber(bytes, clazz);
            return this.toIntegral(parsed, clazz);
        }
        if (value instanceof Date) {
            return BigInteger.valueOf(this.getDateTimeHelper(context).toTimestamp((Date)value));
        }
        if (value instanceof TemporalAccessor) {
            Long timestamp = this.getDateTimeHelper(context).toTimestamp((TemporalAccessor)value);
            if (timestamp == null) {
                throw new HussarIntegrationConvertException("cannot convert integral number from temporal: " + value.getClass());
            }
            return BigInteger.valueOf(timestamp);
        }
        if (value instanceof Enum) {
            return BigInteger.valueOf(((Enum)value).ordinal());
        }
        throw new HussarIntegrationConvertException("cannot convert integral number from: " + value.getClass());
    }

    private BigInteger toIntegral(Number number, Class<?> clazz) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).toBigInteger();
        }
        if (number instanceof Double || number instanceof Float) {
            double floating;
            double d = floating = number instanceof Double ? (Double)number : (double)((Float)number).floatValue();
            if (Double.isNaN(floating)) {
                throw new HussarIntegrationConvertException("cannot convert NaN to integral type: " + clazz);
            }
            if (Double.isInfinite(floating)) {
                NumberTypeInfo info = this.TARGET_CLASS_INFOS.get(clazz);
                if (info == null || info.getCategory() != NumberCategory.INTEGRAL || info.getBytes() <= 0) {
                    throw new HussarIntegrationConvertException("cannot convert +/- Infinity value to integral type: " + clazz);
                }
                switch (info.getBytes()) {
                    case 1: {
                        return BigInteger.valueOf(Math.signum(floating) > 0.0 ? 127L : -128L);
                    }
                    case 2: {
                        return BigInteger.valueOf(Math.signum(floating) > 0.0 ? 32767L : -32768L);
                    }
                    case 4: {
                        return BigInteger.valueOf(Math.signum(floating) > 0.0 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
                    }
                    case 8: {
                        return BigInteger.valueOf(Math.signum(floating) > 0.0 ? Long.MAX_VALUE : Long.MIN_VALUE);
                    }
                }
                throw new HussarIntegrationConvertException("cannot convert +/- Infinity value to integral type: " + clazz);
            }
            return BigInteger.valueOf((long)floating);
        }
        return BigInteger.valueOf(number.longValue());
    }

    private Double toFloating(ConvertContext context, Object value, Class<?> clazz) {
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            try {
                String literal = (String)value;
                Number parsed = this.parseNumber(literal, clazz);
                return parsed.doubleValue();
            }
            catch (Exception ignore) {
                return Double.NaN;
            }
        }
        if (value instanceof byte[]) {
            try {
                byte[] bytes = (byte[])value;
                Number parsed = this.parseNumber(bytes, clazz);
                return parsed.doubleValue();
            }
            catch (Exception ignore) {
                return Double.NaN;
            }
        }
        if (value instanceof Date) {
            return (double)this.getDateTimeHelper(context).toTimestamp((Date)value);
        }
        if (value instanceof TemporalAccessor) {
            Long timestamp = this.getDateTimeHelper(context).toTimestamp((TemporalAccessor)value);
            if (timestamp == null) {
                return Double.NaN;
            }
            return (double)timestamp;
        }
        if (value instanceof Enum) {
            return ((Enum)value).ordinal();
        }
        return Double.NaN;
    }

    private BigDecimal toDecimal(ConvertContext context, Object value, Class<?> clazz) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof Number) {
            return this.toDecimal((Number)value, clazz);
        }
        if (value instanceof Boolean) {
            return BigDecimal.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (value instanceof Character) {
            return BigDecimal.valueOf(((Character)value).charValue());
        }
        if (value instanceof String) {
            String literal = (String)value;
            Number parsed = this.parseNumber(literal, clazz);
            return this.toDecimal(parsed, clazz);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            Number parsed = this.parseNumber(bytes, clazz);
            return this.toDecimal(parsed, clazz);
        }
        if (value instanceof Date) {
            return BigDecimal.valueOf(this.getDateTimeHelper(context).toTimestamp((Date)value));
        }
        if (value instanceof TemporalAccessor) {
            Long timestamp = this.getDateTimeHelper(context).toTimestamp((TemporalAccessor)value);
            if (timestamp == null) {
                throw new HussarIntegrationConvertException("cannot convert decimal number from temporal: " + value.getClass());
            }
            return BigDecimal.valueOf(timestamp);
        }
        if (value instanceof Enum) {
            return BigDecimal.valueOf(((Enum)value).ordinal());
        }
        throw new HussarIntegrationConvertException("cannot convert decimal number from: " + value.getClass());
    }

    private BigDecimal toDecimal(Number number, Class<?> clazz) {
        if (number == null) {
            return null;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Double || number instanceof Float) {
            double floating;
            double d = floating = number instanceof Double ? (Double)number : (double)((Float)number).floatValue();
            if (!Double.isFinite(floating)) {
                throw new HussarIntegrationConvertException("cannot convert non-finite value to decimal: " + clazz);
            }
            return BigDecimal.valueOf(floating);
        }
        long integral = number.longValue();
        double floating = number.doubleValue();
        if (Double.isInfinite(floating)) {
            throw new HussarIntegrationConvertException("cannot convert +/- Infinity value to decimal: " + clazz);
        }
        if (Double.isNaN(floating) && integral != 0L) {
            throw new HussarIntegrationConvertException("cannot convert NaN value to decimal: " + clazz);
        }
        if (integral > 0x1FFFFFFFFFFFFFL || integral < -9007199254740991L) {
            return BigDecimal.valueOf(integral);
        }
        return BigDecimal.valueOf(floating);
    }

    private Number parseNumber(String literal, Class<?> clazz) {
        NumberTypeInfo info = this.TARGET_CLASS_INFOS.get(clazz);
        if (info == null) {
            throw new HussarIntegrationConvertException("unsupported string to number conversion: " + clazz);
        }
        if ((literal = StringUtils.stripToEmpty((String)literal)).isEmpty()) {
            return null;
        }
        char suffix = Character.toUpperCase(literal.charAt(literal.length() - 1));
        if (suffix == 'D' || suffix == 'L' || suffix == 'F') {
            literal = literal.substring(0, literal.length() - 1);
        }
        NumberCategory category = info.getCategory();
        try {
            switch (category) {
                case INTEGRAL: {
                    return new BigDecimal(literal).toBigInteger();
                }
                case FLOATING: {
                    return Double.parseDouble(literal);
                }
                case DECIMAL: {
                    return new BigDecimal(literal);
                }
            }
            throw new HussarIntegrationConvertException("unsupported string to number conversion category: " + (Object)((Object)category));
        }
        catch (NumberFormatException ex) {
            throw new HussarIntegrationConvertException(ex);
        }
    }

    private Number parseNumber(byte[] bytes, Class<?> clazz) {
        NumberTypeInfo info = this.TARGET_CLASS_INFOS.get(clazz);
        Class primitive = Optional.ofNullable(info).map(NumberTypeInfo::getPrimitive).orElse(null);
        int size = Optional.ofNullable(info).map(NumberTypeInfo::getBytes).orElse(0);
        if (size <= 0 || primitive == null) {
            throw new HussarIntegrationConvertException("unsupported bytes to number conversion: " + clazz);
        }
        if (size == 1) {
            return bytes.length > 0 ? bytes[0] : (byte)0;
        }
        byte[] chunk = new byte[size];
        if (bytes.length >= size) {
            System.arraycopy(bytes, 0, chunk, 0, size);
        } else if (DEFAULT_ENDIAN == ByteOrder.LITTLE_ENDIAN) {
            System.arraycopy(bytes, 0, chunk, 0, bytes.length);
        } else {
            System.arraycopy(bytes, 0, chunk, size - bytes.length, bytes.length);
        }
        ByteBuffer buffer = ByteBuffer.wrap(chunk).order(DEFAULT_ENDIAN);
        if (primitive == Short.TYPE) {
            return buffer.getShort();
        }
        if (primitive == Integer.TYPE) {
            return buffer.getInt();
        }
        if (primitive == Long.TYPE) {
            return buffer.getLong();
        }
        if (primitive == Float.TYPE) {
            return Float.valueOf(buffer.getFloat());
        }
        if (primitive == Double.TYPE) {
            return buffer.getDouble();
        }
        throw new HussarIntegrationConvertException("unsupported bytes to number conversion: " + clazz);
    }

    private Number fromIntegral(BigInteger value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return value.intValue();
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return value.longValue();
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return value.byteValue();
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return value.shortValue();
        }
        if (clazz == BigInteger.class) {
            return value;
        }
        if (clazz == AtomicInteger.class) {
            return new AtomicInteger(value.intValue());
        }
        if (clazz == AtomicLong.class) {
            return new AtomicLong(value.longValue());
        }
        if (clazz == LongAdder.class) {
            LongAdder adder = new LongAdder();
            adder.add(value.longValue());
            return adder;
        }
        throw new HussarIntegrationConvertException("unsupported integral number convert type: " + clazz);
    }

    private Number fromFloating(Double value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return value;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Float.valueOf(value.floatValue());
        }
        if (clazz == DoubleAdder.class) {
            DoubleAdder adder = new DoubleAdder();
            adder.add(value);
            return adder;
        }
        throw new HussarIntegrationConvertException("unsupported floating number convert type: " + clazz);
    }

    private Number fromDecimal(BigDecimal value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (clazz == BigDecimal.class) {
            return value;
        }
        throw new HussarIntegrationConvertException("unsupported decimal number convert type: " + clazz);
    }

    protected Map<Class<?>, NumberTypeInfo> getNumberTypeInfos() {
        LinkedHashMap<Class<DoubleAdder>, NumberTypeInfo> map = new LinkedHashMap<Class<DoubleAdder>, NumberTypeInfo>();
        map.put(Byte.TYPE, new NumberTypeInfo(Byte.TYPE, NumberCategory.INTEGRAL, Byte.TYPE, 1));
        map.put(Byte.class, new NumberTypeInfo(Byte.class, NumberCategory.INTEGRAL, Byte.TYPE, 1));
        map.put(Short.TYPE, new NumberTypeInfo(Short.TYPE, NumberCategory.INTEGRAL, Short.TYPE, 2));
        map.put(Short.class, new NumberTypeInfo(Short.class, NumberCategory.INTEGRAL, Short.TYPE, 2));
        map.put(Integer.TYPE, new NumberTypeInfo(Integer.TYPE, NumberCategory.INTEGRAL, Integer.TYPE, 4));
        map.put(Integer.class, new NumberTypeInfo(Integer.class, NumberCategory.INTEGRAL, Integer.TYPE, 4));
        map.put(Long.TYPE, new NumberTypeInfo(Long.TYPE, NumberCategory.INTEGRAL, Long.TYPE, 8));
        map.put(Long.class, new NumberTypeInfo(Long.class, NumberCategory.INTEGRAL, Long.TYPE, 8));
        map.put(Float.TYPE, new NumberTypeInfo(Float.TYPE, NumberCategory.FLOATING, Float.TYPE, 4));
        map.put(Float.class, new NumberTypeInfo(Float.class, NumberCategory.FLOATING, Float.TYPE, 4));
        map.put(Double.TYPE, new NumberTypeInfo(Double.TYPE, NumberCategory.FLOATING, Double.TYPE, 8));
        map.put(Double.class, new NumberTypeInfo(Double.class, NumberCategory.FLOATING, Double.TYPE, 8));
        map.put(BigInteger.class, new NumberTypeInfo(BigInteger.class, NumberCategory.INTEGRAL));
        map.put(BigDecimal.class, new NumberTypeInfo(BigDecimal.class, NumberCategory.DECIMAL));
        map.put(AtomicInteger.class, new NumberTypeInfo(AtomicInteger.class, NumberCategory.INTEGRAL, Integer.TYPE, 4));
        map.put(AtomicLong.class, new NumberTypeInfo(AtomicLong.class, NumberCategory.INTEGRAL, Long.TYPE, 8));
        map.put(LongAdder.class, new NumberTypeInfo(LongAdder.class, NumberCategory.INTEGRAL, Long.TYPE, 8));
        map.put(DoubleAdder.class, new NumberTypeInfo(DoubleAdder.class, NumberCategory.FLOATING, Double.TYPE, 8));
        return Collections.unmodifiableMap(map);
    }

    private DateTimeHelper getDateTimeHelper(ConvertContext context) {
        return context.getCachedBean(DateTimeHelper.class, () -> DateTimeHelper.DEFAULT);
    }

    protected static enum NumberCategory {
        INTEGRAL,
        FLOATING,
        DECIMAL;

    }

    protected static final class NumberTypeInfo {
        private final Class<?> clazz;
        private final NumberCategory category;
        private final Class<?> primitive;
        private final int bytes;

        public NumberTypeInfo(Class<?> clazz, NumberCategory category) {
            this(clazz, category, null, 0);
        }

        public NumberTypeInfo(Class<?> clazz, NumberCategory category, Class<?> primitive, int bytes) {
            this.clazz = clazz;
            this.category = category;
            this.primitive = primitive;
            this.bytes = bytes;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public NumberCategory getCategory() {
            return this.category;
        }

        public Class<?> getPrimitive() {
            return this.primitive;
        }

        public int getBytes() {
            return this.bytes;
        }
    }
}

