/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.common.formdata.FormData;
import com.jxdinfo.hussar.integration.support.common.formdata.utils.InternalFormDataUtils;
import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationEntityException;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationGenericsException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationEntityUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationGenericsUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class MapConverter
extends AbstractBaseTypeConverter<Map<?, ?>> {
    protected final List<MapFactory> factories = this.getMapFactories();

    @Override
    public Map<?, ?> convert(ConvertContext context, Object value, Type type) {
        LinkedHashMap intermediate;
        Triple<Class<? extends Map<?, ?>>, Type, Type> actualMapType = this.getActualMapType(context, type);
        Class clazz = (Class)actualMapType.getLeft();
        Type keyType = (Type)actualMapType.getMiddle();
        Type valueType = (Type)actualMapType.getRight();
        MapFactory factory = this.getMapFactory(clazz);
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            if (context.getFeature("reuse.aggressive") && this.isProbablyReusable(map, keyType, valueType)) {
                return map;
            }
            intermediate = new LinkedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object val = entry.getValue();
                Object convertedKey = context.convert(key, keyType);
                Object convertedValue = context.convert(val, valueType);
                intermediate.put(convertedKey, convertedValue);
            }
        } else if (value instanceof FormData) {
            FormData form = (FormData)value;
            intermediate = new LinkedHashMap();
            for (String key : form.keys()) {
                Object convertedValue;
                Object convertedKey = context.convert(key, keyType);
                List<Object> values = form.getAll(key);
                if (values.isEmpty()) continue;
                if (values.size() == 1 && InternalFormDataUtils.guessShouldUnwrapFormElement(values, valueType) != Boolean.FALSE) {
                    Object element = values.get(0);
                    convertedValue = context.convert(element, valueType);
                } else {
                    convertedValue = context.convert(values, valueType);
                }
                intermediate.put(convertedKey, convertedValue);
            }
        } else if (this.getEntityUtilsBean(context).isProbablyEntity(value.getClass())) {
            intermediate = new LinkedHashMap();
            HussarIntegrationEntityUtils.EntityUtilsBean entityUtils = this.getEntityUtilsBean(context);
            Map<String, HussarIntegrationEntityUtils.EntityPropertyDescriptor> properties = entityUtils.getReadableProperties(value.getClass());
            for (String propertyName : properties.keySet()) {
                Object propertyValue;
                try {
                    propertyValue = entityUtils.getProperty(value, propertyName, true);
                }
                catch (HussarIntegrationEntityException ex) {
                    throw new HussarIntegrationConvertException("Map<T> converter failed to get pojo property: " + propertyName, (Throwable)((Object)ex));
                }
                Object convertedKey = context.convert(propertyName, keyType);
                Object convertedValue = context.convert(propertyValue, valueType);
                intermediate.put(convertedKey, convertedValue);
            }
        } else {
            throw new HussarIntegrationConvertException("Map<T> converter do not support source type: " + value.getClass());
        }
        return factory.create(context, intermediate);
    }

    private Triple<Class<? extends Map<?, ?>>, Type, Type> getActualMapType(ConvertContext context, Type type) {
        if (type instanceof Class) {
            if (!Map.class.isAssignableFrom((Class)type)) {
                throw new HussarIntegrationConvertException("Map<T> converter do not support target type: " + type);
            }
            return Triple.of((Object)((Class)type), Object.class, Object.class);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawClass = (Class)parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (!Map.class.isAssignableFrom(rawClass)) {
                throw new HussarIntegrationConvertException("Map<T> converter do not support target type: " + type);
            }
            Pair<Type, Type> elementTypes = this.getElementTypes(context, rawClass, typeArguments);
            return Triple.of((Object)rawClass, (Object)elementTypes.getKey(), (Object)elementTypes.getValue());
        }
        throw new HussarIntegrationConvertException("unsupported reflect type for Map<T> converter: " + type);
    }

    private Pair<Type, Type> getElementTypes(ConvertContext context, Class<?> mapClass, Type ... typeArguments) {
        HussarIntegrationGenericsUtils.GenericsUtilsBean genericsUtils = this.getGenericsUtils(context);
        try {
            Type[] actualTypeArguments = genericsUtils.resolveSuperTypeArguments(Map.class, mapClass, typeArguments);
            if (ArrayUtils.getLength((Object)actualTypeArguments) < 2) {
                throw new HussarIntegrationConvertException("Map<T> converter cannot extract element type from: " + mapClass);
            }
            return Pair.of((Object)actualTypeArguments[0], (Object)actualTypeArguments[1]);
        }
        catch (HussarIntegrationGenericsException ex) {
            throw new HussarIntegrationConvertException("Map<T> converter cannot extract element type from: " + mapClass);
        }
    }

    private boolean isProbablyReusable(Map<?, ?> value, Type keyType, Type valueType) {
        Class keyClass = TypeUtils.getRawType((Type)keyType, null);
        Class valueClass = TypeUtils.getRawType((Type)valueType, null);
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Class entryKeyClass = Optional.ofNullable(entry.getKey()).map(Object::getClass).orElse(null);
            Class entryValueClass = Optional.ofNullable(entry.getValue()).map(Object::getClass).orElse(null);
            if (keyClass != null && entryKeyClass != null && !keyClass.isAssignableFrom(entryKeyClass)) {
                return false;
            }
            if (valueClass == null || entryValueClass == null || valueClass.isAssignableFrom(entryValueClass)) continue;
            return false;
        }
        return true;
    }

    private HussarIntegrationEntityUtils.EntityUtilsBean getEntityUtilsBean(ConvertContext context) {
        return context.getCachedBean(HussarIntegrationEntityUtils.EntityUtilsBean.class, HussarIntegrationEntityUtils::createUtilsBean);
    }

    private HussarIntegrationGenericsUtils.GenericsUtilsBean getGenericsUtils(ConvertContext context) {
        return context.getCachedBean(HussarIntegrationGenericsUtils.GenericsUtilsBean.class, HussarIntegrationGenericsUtils::createUtilsBean);
    }

    protected MapFactory getMapFactory(Class<? extends Map<?, ?>> target) {
        if (target == null) {
            throw new NullPointerException();
        }
        for (MapFactory factory : this.factories) {
            if (!target.isAssignableFrom(factory.getTargetClass())) continue;
            return factory;
        }
        if (!target.isInterface() && !Modifier.isAbstract(target.getModifiers())) {
            try {
                Constructor<? extends Map<?, ?>> constructor = target.getConstructor(Map.class);
                return new CopyConstructorMapFactory(target, constructor);
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor<? extends Map<?, ?>> constructor2 = target.getConstructor(new Class[0]);
                    return new PutAllMapFactory(target, constructor2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        throw new HussarIntegrationConvertException("Map<T> converter do not support create map type: " + target);
    }

    protected List<MapFactory> getMapFactories() {
        ArrayList factories = new ArrayList();
        factories.add(LambdaMapFactory.of(LinkedHashMap.class, LinkedHashMap::new));
        factories.add(LambdaMapFactory.of(HashMap.class, HashMap::new));
        factories.add(LambdaMapFactory.of(TreeMap.class, TreeMap::new));
        factories.add(LambdaMapFactory.of(ConcurrentHashMap.class, ConcurrentHashMap::new));
        factories.add(LambdaMapFactory.of(ConcurrentSkipListMap.class, ConcurrentSkipListMap::new));
        factories.add(LambdaMapFactory.of(WeakHashMap.class, WeakHashMap::new));
        factories.add(LambdaMapFactory.of(Hashtable.class, Hashtable::new));
        return Collections.unmodifiableList(factories);
    }

    protected static class PutAllMapFactory<T extends Map<?, ?>>
    implements MapFactory {
        private final Class<? extends Map<?, ?>> target;
        private final Constructor<? extends Map<?, ?>> constructor;

        public PutAllMapFactory(Class<? extends Map<?, ?>> target, Constructor<? extends Map<?, ?>> constructor) {
            this.target = target;
            this.constructor = constructor;
        }

        @Override
        public Map<?, ?> create(ConvertContext context, Map<?, ?> source) {
            if (source == null) {
                throw new NullPointerException();
            }
            try {
                Map<?, ?> created = this.constructor.newInstance(new Object[0]);
                created.putAll(source);
                return created;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new HussarIntegrationConvertException("Map<T> converter failed to create target map: " + this.target, ex);
            }
            catch (Exception ex) {
                throw new HussarIntegrationConvertException("Map<T> converter failed to add all elements to empty map", ex);
            }
        }

        @Override
        public Class<? extends Map<?, ?>> getTargetClass() {
            return this.target;
        }
    }

    protected static class CopyConstructorMapFactory<T extends Map<?, ?>>
    implements MapFactory {
        private final Class<? extends Map<?, ?>> target;
        private final Constructor<? extends Map<?, ?>> constructor;

        public CopyConstructorMapFactory(Class<? extends Map<?, ?>> target, Constructor<? extends Map<?, ?>> constructor) {
            this.target = target;
            this.constructor = constructor;
        }

        @Override
        public Map<?, ?> create(ConvertContext context, Map<?, ?> source) {
            try {
                return this.constructor.newInstance(source);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new HussarIntegrationConvertException("Map<T> converter failed to create target map: " + this.target, ex);
            }
        }

        @Override
        public Class<? extends Map<?, ?>> getTargetClass() {
            return this.target;
        }
    }

    protected static class LambdaMapFactory<T extends Map<?, ?>>
    implements MapFactory {
        private final Class<? extends Map<?, ?>> clazz;
        private final Function<Map<?, ?>, T> factory;

        private LambdaMapFactory(Class<T> clazz, Function<Map<?, ?>, T> factory) {
            this.clazz = clazz;
            this.factory = factory;
        }

        public static <T extends Map<?, ?>> LambdaMapFactory<T> of(Class<T> clazz, Function<Map<?, ?>, T> factory) {
            if (clazz == null || factory == null) {
                throw new NullPointerException();
            }
            return new LambdaMapFactory<T>(clazz, factory);
        }

        @Override
        public Map<?, ?> create(ConvertContext context, Map<?, ?> source) {
            return (Map)this.factory.apply(source);
        }

        @Override
        public Class<? extends Map<?, ?>> getTargetClass() {
            return this.clazz;
        }
    }

    protected static interface MapFactory {
        public Map<?, ?> create(ConvertContext var1, Map<?, ?> var2);

        public Class<? extends Map<?, ?>> getTargetClass();
    }
}

