/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.Type;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EnumConverter
extends AbstractBaseTypeConverter<Enum<?>> {
    @Override
    public Enum<?> convert(ConvertContext context, Object value, Type type) {
        Class<Enum<?>> clazz = this.getCheckedEnumClass(type);
        if (value == null) {
            return null;
        }
        if (value.getClass() == clazz) {
            return (Enum)value;
        }
        if (value instanceof Enum) {
            return this.convertNameToEnum(((Enum)value).name(), clazz);
        }
        if (value instanceof Number) {
            if (value instanceof Double || value instanceof Float) {
                double floating;
                double d = floating = value instanceof Double ? (Double)value : (double)((Float)value).floatValue();
                if (!Double.isFinite(floating)) {
                    throw new HussarIntegrationConvertException("invalid enum ordinal number: " + value);
                }
            }
            int ordinal = ((Number)value).intValue();
            Enum<?>[] values = clazz.getEnumConstants();
            if (ordinal < 0 || ordinal >= values.length) {
                throw new HussarIntegrationConvertException("ordinal number of enum '" + clazz.getName() + "' is out of bound: " + value);
            }
            return values[ordinal];
        }
        if (value instanceof CharSequence || value instanceof Character) {
            String name = value.toString();
            return this.convertNameToEnum(name, clazz);
        }
        throw new HussarIntegrationConvertException("cannot convert enum type '" + clazz + "' from: " + value.getClass());
    }

    private Class<? extends Enum<?>> getCheckedEnumClass(Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        if (clazz == null || !clazz.isEnum() || ArrayUtils.isEmpty((Object[])clazz.getEnumConstants())) {
            throw new HussarIntegrationConvertException("enum converter do not support target type: " + type);
        }
        return clazz;
    }

    private Enum<?> convertNameToEnum(String name, Class<? extends Enum<?>> clazz) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        for (Enum<?> value : clazz.getEnumConstants()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)value.name())) continue;
            return value;
        }
        throw new HussarIntegrationConvertException("undefined enum '" + clazz.getName() + "' name: " + name);
    }
}

