/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateConverter
extends AbstractBaseTypeConverter<Date> {
    @Override
    public Date convert(ConvertContext context, Object value, Type type) {
        long timestamp;
        Class<? extends Date> clazz = this.getCheckedDateClass(type);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            if (value instanceof Double || value instanceof Float) {
                double floating;
                double d = floating = value instanceof Double ? (Double)value : (double)((Float)value).floatValue();
                if (!Double.isFinite(floating)) {
                    return null;
                }
            }
            timestamp = ((Number)value).longValue();
        } else if (value instanceof CharSequence) {
            String formatted = value.toString();
            if (StringUtils.isEmpty((CharSequence)formatted)) {
                return null;
            }
            DateTimeHelper helper = this.getDateTimeHelper(context);
            Date date = helper.toDate(formatted);
            if (date == null) {
                throw new HussarIntegrationConvertException("failed to parse date: " + formatted);
            }
            timestamp = helper.toTimestamp(date);
        } else if (value instanceof TemporalAccessor) {
            timestamp = this.getDateTimeHelper(context).toTimestamp((TemporalAccessor)value);
        } else {
            throw new HussarIntegrationConvertException("cannot convert date from: " + value.getClass());
        }
        Date date = this.createDateImpl(clazz);
        date.setTime(timestamp);
        return date;
    }

    private Class<? extends Date> getCheckedDateClass(Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        if (clazz == null || !Date.class.isAssignableFrom(clazz)) {
            throw new HussarIntegrationConvertException("date converter do not support target type: " + type);
        }
        return clazz;
    }

    private Date createDateImpl(Class<? extends Date> clazz) {
        try {
            Constructor<? extends Date> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new HussarIntegrationConvertException("failed to construct date type: " + clazz, ex);
        }
    }

    private DateTimeHelper getDateTimeHelper(ConvertContext context) {
        return context.getCachedBean(DateTimeHelper.class, () -> DateTimeHelper.DEFAULT);
    }
}

