/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationGenericsException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationGenericsUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CollectionConverter
extends AbstractBaseTypeConverter<Collection<?>> {
    protected final List<CollectionFactory> factories = this.getCollectionFactories();

    @Override
    public Collection<?> convert(ConvertContext context, Object value, Type type) {
        Collection<Object> intermediate;
        ArrayList list;
        Pair<Class<? extends Collection<?>>, Type> actualCollectionType = this.getActualCollectionType(context, type);
        Class clazz = (Class)actualCollectionType.getLeft();
        Type elementType = (Type)actualCollectionType.getRight();
        CollectionFactory factory = this.getCollectionFactory(clazz);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (context.getFeature("reuse.aggressive") && this.isProbablyReusable(collection, clazz, elementType)) {
                return collection;
            }
            Collection collection2 = collection;
        }
        if (value instanceof Iterable) {
            list = new ArrayList();
            for (Object item : (Iterable)value) {
                Object converted = context.convert(item, elementType);
                list.add(converted);
            }
            intermediate = list;
        } else if (value instanceof Iterator) {
            list = new ArrayList();
            Iterator iter = (Iterator)value;
            while (iter.hasNext()) {
                Object converted = context.convert(iter.next(), elementType);
                list.add(converted);
            }
            intermediate = list;
        } else if (value instanceof Enumeration) {
            list = new ArrayList();
            Enumeration enumeration = (Enumeration)value;
            while (enumeration.hasMoreElements()) {
                Object converted = context.convert(enumeration.nextElement(), elementType);
                list.add(converted);
            }
            intermediate = list;
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList list2 = new ArrayList(length);
            for (int i = 0; i < length; ++i) {
                Object converted = context.convert(Array.get(value, i), elementType);
                list2.add(converted);
            }
            intermediate = list2;
        } else if (value instanceof CharSequence) {
            intermediate = ((CharSequence)value).codePoints().mapToObj(cp -> new String(Character.toChars(cp))).map(ch -> context.convert(ch, elementType)).collect(Collectors.toList());
        } else if (value instanceof Map) {
            intermediate = ((Map)value).entrySet().stream().map(entry -> context.convert(entry, elementType)).collect(Collectors.toList());
        } else {
            throw new HussarIntegrationConvertException("Collection<T> converter do not support source type: " + value.getClass());
        }
        return factory.create(context, intermediate);
    }

    private Pair<Class<? extends Collection<?>>, Type> getActualCollectionType(ConvertContext context, Type type) {
        if (type instanceof Class) {
            if (!Collection.class.isAssignableFrom((Class)type)) {
                throw new HussarIntegrationConvertException("Collection<T> converter do not support target type: " + type);
            }
            return Pair.of((Object)((Class)type), Object.class);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawClass = (Class)parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (!Collection.class.isAssignableFrom(rawClass)) {
                throw new HussarIntegrationConvertException("Collection<T> converter do not support target type: " + type);
            }
            return Pair.of((Object)rawClass, (Object)this.getElementType(context, rawClass, typeArguments));
        }
        throw new HussarIntegrationConvertException("unsupported reflect type for Collection<T> converter: " + type);
    }

    private Type getElementType(ConvertContext context, Class<?> collectionClass, Type ... typeArguments) {
        HussarIntegrationGenericsUtils.GenericsUtilsBean genericsUtils = this.getGenericsUtils(context);
        try {
            Object[] actualTypeArguments = genericsUtils.resolveSuperTypeArguments(Collection.class, collectionClass, typeArguments);
            if (ArrayUtils.isEmpty((Object[])actualTypeArguments)) {
                throw new HussarIntegrationConvertException("Collection<T> converter cannot extract element type from: " + collectionClass);
            }
            return actualTypeArguments[0];
        }
        catch (HussarIntegrationGenericsException ex) {
            throw new HussarIntegrationConvertException("Collection<T> converter cannot extract element type from: " + collectionClass);
        }
    }

    private HussarIntegrationGenericsUtils.GenericsUtilsBean getGenericsUtils(ConvertContext context) {
        return context.getCachedBean(HussarIntegrationGenericsUtils.GenericsUtilsBean.class, HussarIntegrationGenericsUtils::createUtilsBean);
    }

    private boolean isProbablyReusable(Collection<?> value, Class<?> collectionClass, Type elementType) {
        if (collectionClass != null && !collectionClass.isAssignableFrom(value.getClass())) {
            return false;
        }
        Class elementClass = TypeUtils.getRawType((Type)elementType, null);
        for (Object item : value) {
            Class itemClass = Optional.ofNullable(item).map(Object::getClass).orElse(null);
            if (itemClass == null || elementClass == null || elementClass.isAssignableFrom(itemClass)) continue;
            return false;
        }
        return true;
    }

    protected CollectionFactory getCollectionFactory(Class<? extends Collection<?>> target) {
        if (target == null) {
            throw new NullPointerException();
        }
        for (CollectionFactory factory : this.factories) {
            if (!target.isAssignableFrom(factory.getTargetClass())) continue;
            return factory;
        }
        if (!target.isInterface() && !Modifier.isAbstract(target.getModifiers())) {
            try {
                Constructor<? extends Collection<?>> constructor = target.getConstructor(Collection.class);
                return new CopyConstructorCollectionFactory(target, constructor);
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor<? extends Collection<?>> constructor2 = target.getConstructor(new Class[0]);
                    return new AddAllCollectionFactory(target, constructor2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        throw new HussarIntegrationConvertException("Collection<T> converter do not support create collection type: " + target);
    }

    protected List<CollectionFactory> getCollectionFactories() {
        ArrayList factories = new ArrayList();
        factories.add(LambdaCollectionFactory.of(ArrayList.class, ArrayList::new));
        factories.add(LambdaCollectionFactory.of(LinkedHashSet.class, LinkedHashSet::new));
        factories.add(LambdaCollectionFactory.of(ArrayDeque.class, ArrayDeque::new));
        factories.add(LambdaCollectionFactory.of(LinkedList.class, LinkedList::new));
        factories.add(LambdaCollectionFactory.of(HashSet.class, HashSet::new));
        factories.add(LambdaCollectionFactory.of(TreeSet.class, TreeSet::new));
        factories.add(LambdaCollectionFactory.of(ConcurrentSkipListSet.class, ConcurrentSkipListSet::new));
        factories.add(LambdaCollectionFactory.of(CopyOnWriteArrayList.class, CopyOnWriteArrayList::new));
        factories.add(LambdaCollectionFactory.of(CopyOnWriteArraySet.class, CopyOnWriteArraySet::new));
        factories.add(LambdaCollectionFactory.of(ConcurrentLinkedDeque.class, ConcurrentLinkedDeque::new));
        factories.add(LambdaCollectionFactory.of(ConcurrentLinkedQueue.class, ConcurrentLinkedQueue::new));
        factories.add(LambdaCollectionFactory.of(Vector.class, Vector::new));
        factories.add(LambdaCollectionFactory.of(Stack.class, iter -> {
            if (iter == null) {
                throw new NullPointerException();
            }
            Stack stack = new Stack();
            for (Object item : iter) {
                stack.push(item);
            }
            return stack;
        }));
        return Collections.unmodifiableList(factories);
    }

    protected static class AddAllCollectionFactory<T extends Collection<?>>
    implements CollectionFactory {
        private final Class<? extends Collection<?>> target;
        private final Constructor<? extends Collection<?>> constructor;

        public AddAllCollectionFactory(Class<? extends Collection<?>> target, Constructor<? extends Collection<?>> constructor) {
            this.target = target;
            this.constructor = constructor;
        }

        @Override
        public Collection<?> create(ConvertContext context, Collection<?> source) {
            if (source == null) {
                throw new NullPointerException();
            }
            try {
                Collection<?> created = this.constructor.newInstance(new Object[0]);
                created.addAll(source);
                return created;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new HussarIntegrationConvertException("Collection<T> converter failed to create target collection: " + this.target, ex);
            }
            catch (Exception ex) {
                throw new HussarIntegrationConvertException("Collection<T> converter failed to add all elements to empty collection", ex);
            }
        }

        @Override
        public Class<? extends Collection<?>> getTargetClass() {
            return this.target;
        }
    }

    protected static class CopyConstructorCollectionFactory<T extends Collection<?>>
    implements CollectionFactory {
        private final Class<? extends Collection<?>> target;
        private final Constructor<? extends Collection<?>> constructor;

        public CopyConstructorCollectionFactory(Class<? extends Collection<?>> target, Constructor<? extends Collection<?>> constructor) {
            this.target = target;
            this.constructor = constructor;
        }

        @Override
        public Collection<?> create(ConvertContext context, Collection<?> source) {
            try {
                return this.constructor.newInstance(source);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new HussarIntegrationConvertException("Collection<T> converter failed to create target collection: " + this.target, ex);
            }
        }

        @Override
        public Class<? extends Collection<?>> getTargetClass() {
            return this.target;
        }
    }

    protected static class LambdaCollectionFactory<T extends Collection<?>>
    implements CollectionFactory {
        private final Class<? extends Collection<?>> clazz;
        private final Function<Collection<?>, T> factory;

        private LambdaCollectionFactory(Class<T> clazz, Function<Collection<?>, T> factory) {
            this.clazz = clazz;
            this.factory = factory;
        }

        public static <T extends Collection<?>> LambdaCollectionFactory<T> of(Class<T> clazz, Function<Collection<?>, T> factory) {
            if (clazz == null || factory == null) {
                throw new NullPointerException();
            }
            return new LambdaCollectionFactory<T>(clazz, factory);
        }

        @Override
        public Collection<?> create(ConvertContext context, Collection<?> source) {
            return (Collection)this.factory.apply(source);
        }

        @Override
        public Class<? extends Collection<?>> getTargetClass() {
            return this.clazz;
        }
    }

    protected static interface CollectionFactory {
        public Collection<?> create(ConvertContext var1, Collection<?> var2);

        public Class<? extends Collection<?>> getTargetClass();
    }
}

