/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CharacterConverter
extends AbstractBaseTypeConverter<Character> {
    private static final Set<Class<?>> TARGET_CLASSES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Character.TYPE, Character.class)));

    @Override
    public boolean isTargetClassesExhaustive() {
        return true;
    }

    @Override
    public Set<Class<?>> getTargetClasses() {
        return TARGET_CLASSES;
    }

    @Override
    public Character convert(ConvertContext context, Object value, Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        if (!TARGET_CLASSES.contains(clazz)) {
            throw new HussarIntegrationConvertException("character converter do not support target type: " + type);
        }
        Character ch = this.convertToChar(value);
        if (ch == null && clazz.isPrimitive()) {
            ch = Character.valueOf('\u0000');
        }
        return ch;
    }

    private Character convertToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof Boolean) {
            return Character.valueOf((Boolean)value != false ? (char)'T' : 'F');
        }
        if (value instanceof Number) {
            return Character.valueOf((char)((Number)value).longValue());
        }
        if (value instanceof CharSequence) {
            String literal = ((CharSequence)value).toString();
            return StringUtils.isNotEmpty((CharSequence)literal) ? Character.valueOf(literal.charAt(0)) : null;
        }
        throw new HussarIntegrationConvertException("cannot convert char from: " + value.getClass());
    }
}

