/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;

public class BytesConverter
extends AbstractBaseTypeConverter<byte[]> {
    @Override
    public byte[] convert(ConvertContext context, Object value, Type type) {
        if (!this.accepts(context, type)) {
            throw new HussarIntegrationConvertException("bytes converter do not support target type: " + type);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof CharSequence) {
            return value.toString().getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof Character) {
            return String.valueOf(((Character)value).charValue()).getBytes(StandardCharsets.UTF_8);
        }
        if (value instanceof Blob) {
            try {
                return IOUtils.toByteArray((InputStream)((Blob)value).getBinaryStream());
            }
            catch (IOException | SQLException ex) {
                throw new HussarIntegrationConvertException("blob to string conversion failed", ex);
            }
        }
        if (value instanceof Clob) {
            try {
                return IOUtils.toByteArray((Reader)((Clob)value).getCharacterStream(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | SQLException ex) {
                throw new HussarIntegrationConvertException("blob to string conversion failed", ex);
            }
        }
        HussarIntegrationJsonUtils.JsonUtilsBean jsonUtils = context.getCachedBean(HussarIntegrationJsonUtils.JsonUtilsBean.class, HussarIntegrationJsonUtils::createUtilsBean);
        return jsonUtils.toByteArray(value);
    }
}

