/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BooleanConverter
extends AbstractBaseTypeConverter<Boolean> {
    private static final Set<Class<?>> TARGET_CLASSES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Boolean.TYPE, Boolean.class)));

    @Override
    public boolean isTargetClassesExhaustive() {
        return true;
    }

    @Override
    public Set<Class<?>> getTargetClasses() {
        return TARGET_CLASSES;
    }

    @Override
    public Boolean convert(ConvertContext context, Object value, Type type) {
        Class<?> clazz = this.getRawTargetClass(type);
        if (!TARGET_CLASSES.contains(clazz)) {
            throw new HussarIntegrationConvertException("boolean converter do not support target type: " + type);
        }
        Boolean truthy = this.truthy(value);
        if (truthy == null && clazz.isPrimitive()) {
            truthy = false;
        }
        return truthy;
    }

    private Boolean truthy(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Double || value instanceof Float) {
            double floating = value instanceof Double ? (Double)value : (double)((Float)value).floatValue();
            return Double.isInfinite(floating) || !Double.isNaN(floating) && floating != 0.0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).signum() != 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).signum() != 0;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof CharSequence) {
            return Boolean.parseBoolean(((CharSequence)value).toString());
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) != 0;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        return true;
    }
}

