/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert.core;

import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.convert.Converter;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.reflect.TypeUtils;

public class ArrayConverter
implements Converter {
    @Override
    public boolean accepts(ConvertContext context, Type type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        return type instanceof GenericArrayType;
    }

    @Override
    public <T> T convert(ConvertContext context, Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (context.getFeature("reuse.aggressive") && this.isProbablyReusable(value, type)) {
            return (T)value;
        }
        Type itemType = this.getItemType(type);
        if (itemType instanceof Class && ((Class)itemType).isPrimitive()) {
            return (T)this.convertPrimitiveArray(context, value, (Class)itemType);
        }
        return (T)this.convertObjectArray(context, value, itemType);
    }

    private boolean isProbablyReusable(Object value, Type type) {
        Class sourceClass = Optional.ofNullable(value).map(Object::getClass).orElse(null);
        Class targetClass = TypeUtils.getRawType((Type)type, null);
        return sourceClass == null || targetClass == null || targetClass.isAssignableFrom(sourceClass);
    }

    private Type getItemType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (!clazz.isArray()) {
                throw new HussarIntegrationConvertException("array converter do not support type: " + type);
            }
            return clazz.getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        throw new HussarIntegrationConvertException("array converter do not support type: " + type);
    }

    private Object convertObjectArray(ConvertContext context, Object value, Type itemType) {
        if (value == null) {
            return null;
        }
        try {
            List list = (List)context.convert(value, TypeUtils.parameterize(List.class, (Type[])new Type[]{itemType}));
            return list.toArray();
        }
        catch (HussarIntegrationConvertException ex) {
            throw new HussarIntegrationConvertException("array converter failed to convert", (Throwable)((Object)ex));
        }
    }

    public Object convertPrimitiveArray(ConvertContext context, Object value, Class<?> itemClass) {
        List list;
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
            int length = Array.getLength(value);
            if (value.getClass().getComponentType() == itemClass) {
                Object array = Array.newInstance(itemClass, length);
                System.arraycopy(value, 0, array, 0, length);
                return array;
            }
        } else if (value instanceof CharSequence) {
            if (itemClass == Byte.TYPE) {
                return ((CharSequence)value).toString().getBytes(StandardCharsets.UTF_8);
            }
            if (itemClass == Character.TYPE) {
                CharSequence sequence = (CharSequence)value;
                char[] chars = new char[sequence.length()];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = sequence.charAt(i);
                }
                return chars;
            }
            if (itemClass == Integer.TYPE) {
                return ((CharSequence)value).codePoints().toArray();
            }
        }
        try {
            list = (List)context.convert(value, TypeUtils.parameterize(List.class, (Type[])new Type[]{itemClass}));
        }
        catch (HussarIntegrationConvertException ex) {
            throw new HussarIntegrationConvertException("array converter failed to convert", (Throwable)((Object)ex));
        }
        Object array = Array.newInstance(itemClass, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }
}

