/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert;

import com.jxdinfo.hussar.integration.support.convert.AbstractBaseTypeConverter;
import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.convert.Converter;
import com.jxdinfo.hussar.integration.support.convert.spi.ConverterProvider;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationGenericsUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class AbstractConvertContext
implements ConvertContext {
    private static final int DEFAULT_CACHE_CAPACITY = 32;
    private final Map<Class<?>, Converter> converterShortcuts;
    private final List<Converter> nonFinalConverters;
    private final ConcurrentMap<Class<?>, Converter> cache;
    private final Map<Class<?>, Object> beans = new ConcurrentHashMap();
    private final Set<String> features;

    public AbstractConvertContext(boolean oneshot, ConverterProvider.Options options, List<ConverterProvider> converterProviders, String ... features) {
        this(oneshot, AbstractConvertContext.getConvertersFromProviders(options, converterProviders), features);
    }

    public AbstractConvertContext(boolean oneshot, List<Converter> converters, String ... features) {
        this.cache = new ConcurrentReferenceHashMap(32, oneshot ? ConcurrentReferenceHashMap.ReferenceType.WEAK : ConcurrentReferenceHashMap.ReferenceType.SOFT);
        LinkedHashMap converterMap = new LinkedHashMap();
        ArrayList<Converter> converterList = new ArrayList<Converter>();
        for (Converter converter : converters) {
            AbstractConvertContext.registerConverter(converterMap, converterList, converter);
        }
        this.converterShortcuts = Collections.unmodifiableMap(converterMap);
        this.nonFinalConverters = Collections.unmodifiableList(converterList);
        this.features = new LinkedHashSet<String>(Arrays.asList(features));
    }

    @Override
    public <T> T convert(Object value, Type type) {
        if (type instanceof HussarIntegrationGenericsUtils.LazyType) {
            type = ((HussarIntegrationGenericsUtils.LazyType)type).resolve();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        if (value != null && type instanceof Class && ((Class)type).isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        Converter converter = this.getConverter(type);
        if (converter == null) {
            if (value == null) {
                return null;
            }
            throw new HussarIntegrationConvertException("no suitable converter for target type: " + type);
        }
        return converter.convert(this, value, type);
    }

    @Override
    public <T> T getCachedBean(Class<T> clazz, Supplier<T> factory) {
        if (clazz == null || factory == null) {
            throw new NullPointerException();
        }
        return (T)this.beans.computeIfAbsent(clazz, cls -> factory.get());
    }

    @Override
    public boolean getFeature(String name) {
        return this.features.contains(name);
    }

    public void setFeature(String name, boolean value) {
        if (value) {
            this.features.add(name);
        } else {
            this.features.remove(name);
        }
    }

    protected Converter getConverter(Type type) {
        Class clazz = type instanceof Class ? (Class)type : (type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : null);
        return this.cache.computeIfAbsent(clazz, cls -> {
            Converter converterByMap = this.converterShortcuts.get(clazz);
            if (converterByMap != null) {
                return converterByMap;
            }
            for (Converter converterByList : this.nonFinalConverters) {
                if (!converterByList.accepts(this, type)) continue;
                return converterByList;
            }
            return null;
        });
    }

    private static void registerConverter(Map<Class<?>, Converter> converterShortcuts, List<Converter> nonFinalConverters, Converter converter) {
        if (converter instanceof AbstractBaseTypeConverter) {
            AbstractBaseTypeConverter superTypeConverter = (AbstractBaseTypeConverter)converter;
            for (Class<?> targetClass : superTypeConverter.getTargetClasses()) {
                converterShortcuts.putIfAbsent(targetClass, converter);
            }
            if (!superTypeConverter.isTargetClassesExhaustive()) {
                nonFinalConverters.add(converter);
            }
        } else {
            nonFinalConverters.add(converter);
        }
    }

    private static List<Converter> getConvertersFromProviders(ConverterProvider.Options options, List<ConverterProvider> converterProviders) {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        for (ConverterProvider converterProvider : converterProviders) {
            List<Converter> convertersOfProvider = converterProvider.getConverters(options);
            if (!CollectionUtils.isNotEmpty(converterProviders)) continue;
            converters.addAll(convertersOfProvider);
        }
        return converters;
    }

    protected static List<ConverterProvider> findConverterProviders() {
        return AbstractConvertContext.findConverterProviders(null);
    }

    protected static List<ConverterProvider> findConverterProviders(ClassLoader classLoader) {
        ArrayList<ConverterProvider> converterProviders = new ArrayList<ConverterProvider>();
        ServiceLoader<ConverterProvider> serviceLoader = AbstractConvertContext.getConverterProviderServiceLoader(classLoader);
        for (ConverterProvider converterProvider : serviceLoader) {
            converterProviders.add(converterProvider);
        }
        return converterProviders;
    }

    private static ServiceLoader<ConverterProvider> getConverterProviderServiceLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            return classLoader == null ? ServiceLoader.load(ConverterProvider.class) : ServiceLoader.load(ConverterProvider.class, classLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<ConverterProvider>>(){

            @Override
            public ServiceLoader<ConverterProvider> run() {
                return classLoader == null ? ServiceLoader.load(ConverterProvider.class) : ServiceLoader.load(ConverterProvider.class, classLoader);
            }
        });
    }
}

