/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.convert;

import com.jxdinfo.hussar.integration.support.convert.ConvertContext;
import com.jxdinfo.hussar.integration.support.convert.Converter;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationConvertException;
import com.jxdinfo.hussar.integration.support.exception.HussarIntegrationGenericsException;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationGenericsUtils;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractBaseTypeConverter<T>
implements Converter {
    private volatile Class<?> targetClass = null;

    public boolean isTargetClassesExhaustive() {
        Class<?> targetSuperClass = this.getTargetSuperClass();
        return targetSuperClass != null && Modifier.isFinal(targetSuperClass.getModifiers());
    }

    public Set<Class<?>> getTargetClasses() {
        Class<?> targetSuperClass = this.getTargetSuperClass();
        return targetSuperClass != null ? Collections.singleton(targetSuperClass) : Collections.emptySet();
    }

    public Class<?> getTargetSuperClass() {
        return this.getTargetClass();
    }

    @Override
    public boolean accepts(ConvertContext context, Type type) {
        if (type == null) {
            return false;
        }
        Class<?> clazz = this.getRawTargetClass(type);
        if (clazz == null) {
            return false;
        }
        Set<Class<?>> allTargetClasses = this.getTargetClasses();
        if (allTargetClasses != null && allTargetClasses.contains(clazz)) {
            return true;
        }
        return !this.isTargetClassesExhaustive() && this.getTargetSuperClass().isAssignableFrom(clazz);
    }

    @Override
    public abstract T convert(ConvertContext var1, Object var2, Type var3);

    protected Class<?> getRawTargetClass(Type type) {
        Class clazz;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            clazz = (Class)parameterizedType.getRawType();
        } else {
            clazz = null;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> getTargetClass() {
        if (this.targetClass == null) {
            AbstractBaseTypeConverter abstractBaseTypeConverter = this;
            synchronized (abstractBaseTypeConverter) {
                if (this.targetClass == null) {
                    this.targetClass = this.resolveTargetClass();
                }
            }
        }
        return this.targetClass;
    }

    private Class<?> resolveTargetClass() {
        try {
            Object[] typeArguments = HussarIntegrationGenericsUtils.resolveSuperTypeArguments(AbstractBaseTypeConverter.class, this.getClass(), new Type[0]);
            if (ArrayUtils.isEmpty((Object[])typeArguments)) {
                throw new HussarIntegrationConvertException("illegal converter super class arguments: " + Arrays.toString(typeArguments));
            }
            Object targetType = typeArguments[0];
            if (targetType instanceof Class) {
                return (Class)targetType;
            }
            if (targetType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)targetType).getRawType();
            }
            throw new HussarIntegrationConvertException("illegal converter target type: " + targetType);
        }
        catch (HussarIntegrationGenericsException ex) {
            throw new HussarIntegrationConvertException("cannot resolve converter target class", (Throwable)((Object)ex));
        }
    }
}

