/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.springframework.http.ContentDisposition;
import org.springframework.lang.NonNull;
import org.springframework.web.multipart.MultipartFile;

public class RequestPartMultipartFile
implements MultipartFile {
    private final Part part;
    private String originalFilename;

    public RequestPartMultipartFile(Part part) {
        this.part = part;
    }

    public static RequestPartMultipartFile of(Part part) {
        if (part == null) {
            throw new IllegalArgumentException("missing non-null 'part'");
        }
        RequestPartMultipartFile multipartFile = new RequestPartMultipartFile(part);
        multipartFile.setOriginalFilename(RequestPartMultipartFile.tryGetOriginalFilename(part));
        return multipartFile;
    }

    public static RequestPartMultipartFile of(Part part, String originalFilename) {
        if (part == null) {
            throw new IllegalArgumentException("missing non-null 'part'");
        }
        RequestPartMultipartFile multipartFile = new RequestPartMultipartFile(part);
        multipartFile.setOriginalFilename(originalFilename);
        return multipartFile;
    }

    private static String tryGetOriginalFilename(Part part) {
        String headerValue = part.getHeader("Content-Disposition");
        ContentDisposition disposition = ContentDisposition.parse((String)headerValue);
        String filename = disposition.getFilename();
        if (filename != null) {
            if (filename.startsWith("=?") && filename.endsWith("?=")) {
                try {
                    Method decodeText = Class.forName("javax.mail.internet.MimeUtility").getMethod("decodeText", String.class);
                    return (String)decodeText.invoke(null, filename);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return filename;
        }
        try {
            return part.getSubmittedFileName();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @NonNull
    public String getName() {
        return this.part.getName();
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public void setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    public boolean isEmpty() {
        return this.part.getSize() == 0L;
    }

    public long getSize() {
        return this.part.getSize();
    }

    @NonNull
    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.part.getInputStream());
    }

    @NonNull
    public InputStream getInputStream() throws IOException {
        return this.part.getInputStream();
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        this.part.write(dest.getPath());
        if (dest.isAbsolute() && !dest.exists()) {
            IOUtils.copy((InputStream)this.part.getInputStream(), (OutputStream)Files.newOutputStream(dest.toPath(), new OpenOption[0]));
        }
    }

    public void transferTo(@NonNull Path dest) throws IOException, IllegalStateException {
        IOUtils.copy((InputStream)this.part.getInputStream(), (OutputStream)Files.newOutputStream(dest, new OpenOption[0]));
    }

    public String toString() {
        return "RequestPartMultipartFile{" + (this.originalFilename != null ? ", originalFilename='" + this.originalFilename + "', " : "") + "part=" + this.part + '}';
    }
}

