/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class LocalFileMultipartFile
implements MultipartFile {
    private final String name;
    private String contentType;
    private String originalFilename;
    private final File localFile;

    private LocalFileMultipartFile(String name, File localFile) {
        this.name = name;
        this.localFile = localFile;
    }

    public static LocalFileMultipartFile of(String name, File localFile) {
        String contentType = LocalFileMultipartFile.tryGetContentType(localFile);
        return LocalFileMultipartFile.of(name, localFile, contentType);
    }

    public static LocalFileMultipartFile of(String name, File localFile, String contentType) {
        String originalFilename = localFile != null ? localFile.getName() : null;
        return LocalFileMultipartFile.of(name, localFile, contentType, originalFilename);
    }

    public static LocalFileMultipartFile of(String name, File localFile, String contentType, String originalFilename) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("missing non-empty 'name'");
        }
        if (localFile == null) {
            throw new IllegalArgumentException("missing non-null 'localFile'");
        }
        LocalFileMultipartFile multipartFile = new LocalFileMultipartFile(name, localFile);
        multipartFile.setContentType(contentType);
        multipartFile.setOriginalFilename(originalFilename);
        return multipartFile;
    }

    private static String tryGetContentType(File localFile) {
        if (localFile == null) {
            return null;
        }
        String contentType = null;
        try {
            contentType = Files.probeContentType(localFile.toPath());
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        if (StringUtils.isNotEmpty((CharSequence)contentType)) {
            return contentType;
        }
        return null;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public void setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isEmpty() {
        return this.getSize() == 0L;
    }

    public long getSize() {
        return this.localFile.length();
    }

    @Nonnull
    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)Files.newInputStream(this.localFile.toPath(), new OpenOption[0]));
    }

    @Nonnull
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.localFile.toPath(), new OpenOption[0]);
    }

    public void transferTo(@Nonnull File dest) throws IOException, IllegalStateException {
        FileUtils.copyFile((File)this.localFile, (File)dest);
    }

    public String toString() {
        return "LocalFileMultipartFile{name='" + this.name + '\'' + (this.contentType != null ? ", contentType='" + this.contentType + '\'' : "") + (this.originalFilename != null ? ", originalFilename='" + this.originalFilename + '\'' : "") + ", localFile=" + this.localFile + '}';
    }
}

