/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.multipart;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.web.multipart.MultipartFile;

public class ByteArrayMultipartFile
implements MultipartFile {
    private final String name;
    private String contentType;
    private String originalFilename;
    private final byte[] bytes;

    private ByteArrayMultipartFile(String name, byte[] bytes) {
        this.name = name;
        this.bytes = bytes;
    }

    public static ByteArrayMultipartFile of(String name, byte[] bytes) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("missing non-empty 'name'");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("missing non-null 'bytes'");
        }
        return new ByteArrayMultipartFile(name, bytes);
    }

    public static ByteArrayMultipartFile of(String name, String contentType, byte[] bytes) {
        ByteArrayMultipartFile multipartFile = ByteArrayMultipartFile.of(name, bytes);
        multipartFile.setContentType(contentType);
        return multipartFile;
    }

    public static ByteArrayMultipartFile of(String name, String contentType, String originalFilename, byte[] bytes) {
        ByteArrayMultipartFile multipartFile = ByteArrayMultipartFile.of(name, bytes);
        multipartFile.setContentType(contentType);
        multipartFile.setOriginalFilename(originalFilename);
        return multipartFile;
    }

    public static ByteArrayMultipartFile of(MultipartFile multipartFile) throws IOException {
        if (multipartFile == null) {
            throw new NullPointerException();
        }
        return ByteArrayMultipartFile.of(multipartFile.getName(), multipartFile.getContentType(), multipartFile.getOriginalFilename(), multipartFile.getBytes());
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public void setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public long getSize() {
        return this.bytes.length;
    }

    @NonNull
    public byte[] getBytes() {
        return this.bytes;
    }

    @NonNull
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        IOUtils.copy((InputStream)this.getInputStream(), (OutputStream)Files.newOutputStream(dest.toPath(), new OpenOption[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayMultipartFile that = (ByteArrayMultipartFile)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.originalFilename, that.originalFilename) && Objects.deepEquals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.contentType, this.originalFilename, Arrays.hashCode(this.bytes));
    }

    public String toString() {
        return "ByteArrayMultipartFile{name='" + this.name + '\'' + (this.contentType != null ? ", contentType='" + this.contentType + '\'' : "") + (this.originalFilename != null ? ", originalFilename='" + this.originalFilename + '\'' : "") + ", bytes=" + (this.isEmpty() ? "<empty>" : "<" + this.bytes.length + " bytes>") + '}';
    }
}

