/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.formdata.utils;

import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationGenericsUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public final class InternalFormDataUtils {
    private InternalFormDataUtils() {
    }

    public static Boolean guessShouldUnwrapFormElement(List<Object> actualValue, Type expectType) {
        if (actualValue != null && actualValue.size() != 1) {
            return false;
        }
        int expectLevel = 0;
        Class<Object> expectElement = expectType;
        while (true) {
            Class rawType;
            if (expectElement instanceof Class) {
                if (!Collection.class.isAssignableFrom(expectElement)) break;
                ++expectLevel;
                expectElement = Object.class;
                continue;
            }
            if (!(expectElement instanceof ParameterizedType) || !Collection.class.isAssignableFrom(rawType = (Class)((ParameterizedType)((Object)expectElement)).getRawType())) break;
            ++expectLevel;
            Object[] args = HussarIntegrationGenericsUtils.resolveSuperTypeArguments(Collection.class, rawType, new Type[0]);
            expectElement = ArrayUtils.isNotEmpty((Object[])args) ? args[0] : Object.class;
        }
        int actualLevel = 0;
        List<Object> actualElement = actualValue;
        boolean recursive = false;
        IdentityHashSet<List<Object>> history = new IdentityHashSet<List<Object>>();
        while (true) {
            if (history.contains(actualElement)) {
                recursive = true;
                break;
            }
            history.add(actualElement);
            if (!(actualElement instanceof Collection)) break;
            ++actualLevel;
            if (((Collection)actualElement).isEmpty()) {
                actualElement = null;
                continue;
            }
            actualElement = ((Collection)actualElement).stream().filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (!recursive && actualElement != null) {
            return expectLevel < actualLevel;
        }
        return null;
    }

    public static class IdentityHashSet<E>
    extends AbstractSet<E>
    implements Set<E> {
        private final Set<IdentityWrapper<E>> delegate;

        public IdentityHashSet() {
            this.delegate = new HashSet<IdentityWrapper<E>>();
        }

        public IdentityHashSet(Collection<? extends E> collection) {
            this.delegate = new HashSet<IdentityWrapper<E>>(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
            this.addAll(collection);
        }

        public IdentityHashSet(int initialCapacity, float loadFactor) {
            this.delegate = new HashSet<IdentityWrapper<E>>(initialCapacity, loadFactor);
        }

        public IdentityHashSet(int initialCapacity) {
            this.delegate = new HashSet<IdentityWrapper<E>>(initialCapacity);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object elem) {
            return this.delegate.contains(new IdentityWrapper<Object>(elem));
        }

        @Override
        public boolean add(E elem) {
            return this.delegate.add(new IdentityWrapper<E>(elem));
        }

        @Override
        public boolean remove(Object elem) {
            return this.delegate.remove(new IdentityWrapper<Object>(elem));
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Iterator<E> iterator() {
            return new IteratorDelegate<E>(this.delegate.iterator());
        }

        private static final class IteratorDelegate<E>
        implements Iterator<E> {
            private final Iterator<IdentityWrapper<E>> delegate;

            public IteratorDelegate(Iterator<IdentityWrapper<E>> delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public E next() {
                return this.delegate.next().getReferent();
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        }

        private static class IdentityWrapper<T> {
            private final T referent;

            public IdentityWrapper(T referent) {
                this.referent = referent;
            }

            public T getReferent() {
                return this.referent;
            }

            public int hashCode() {
                return System.identityHashCode(this.referent);
            }

            public boolean equals(Object other) {
                return other instanceof IdentityWrapper && this.referent == ((IdentityWrapper)other).referent;
            }

            public String toString() {
                return Objects.toString(this.referent);
            }
        }
    }
}

