/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.formdata;

import com.jxdinfo.hussar.integration.support.common.formdata.AbstractFormData;
import com.jxdinfo.hussar.integration.support.common.formdata.FormData;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationConvertUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriUtils;

public class UrlEncodedFormData
extends AbstractFormData {
    public UrlEncodedFormData() {
    }

    public UrlEncodedFormData(FormData form) {
        super(form);
    }

    @Override
    protected boolean acceptValue(Object value) {
        return !(value instanceof MultipartFile) && (this.isTextualAtom(value) || this.isBinaryAtom(value) || this.isTextualCollection(value) || this.isJsonSerializable(value));
    }

    protected boolean isTextualCollection(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().anyMatch(this::isTextualAtom);
        }
        return false;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        boolean first = true;
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.entries()) {
            buffer.setLength(0);
            if (!first) {
                buffer.append("&");
            }
            String name = entry.getKey();
            Object value = entry.getValue();
            buffer.append(UriUtils.encodeQueryParam((String)name, (Charset)StandardCharsets.UTF_8)).append('=');
            if (this.isTextualAtom(value)) {
                String string = HussarIntegrationConvertUtils.convert(value, String.class);
                buffer.append(UriUtils.encodeQueryParam((String)string, (Charset)StandardCharsets.UTF_8));
                out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
            } else if (this.isBinaryAtom(value)) {
                out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                byte[] bytes = HussarIntegrationConvertUtils.convert(value, byte[].class);
                out.write(bytes);
            } else if (this.isTextualCollection(value)) {
                boolean firstItem = true;
                for (Object item : (Collection)value) {
                    if (!firstItem) {
                        buffer.append(',');
                    }
                    String itemString = HussarIntegrationConvertUtils.convert(item, String.class);
                    buffer.append(UriUtils.encodeQueryParam((String)itemString, (Charset)StandardCharsets.UTF_8));
                    firstItem = false;
                }
                out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
            } else if (this.isJsonSerializable(value)) {
                String json = HussarIntegrationJsonUtils.toString(value);
                buffer.append(UriUtils.encodeQueryParam((String)json, (Charset)StandardCharsets.UTF_8));
                out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
            } else {
                throw new IllegalStateException("unexpected form value: " + value);
            }
            first = false;
        }
    }

    public String toString() {
        return "UrlEncodedFormData{data=" + this.data + '}';
    }
}

