/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.formdata;

import com.jxdinfo.hussar.integration.support.common.formdata.AbstractFormData;
import com.jxdinfo.hussar.integration.support.common.formdata.FormData;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationConvertUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriUtils;

public class MultipartFormData
extends AbstractFormData {
    private String boundary;
    private volatile String generatedBoundary;

    public MultipartFormData() {
    }

    public MultipartFormData(FormData form) {
        super(form);
    }

    @Override
    protected boolean acceptValue(Object value) {
        return value instanceof MultipartFile || this.isTextualAtom(value) || this.isBinaryAtom(value) || this.isJsonSerializable(value);
    }

    public boolean isExplicitBoundary() {
        return this.boundary != null;
    }

    public String getBoundary() {
        return this.boundary != null ? this.boundary : this.getGeneratedBoundary();
    }

    public void setBoundary(String boundary) {
        this.boundary = boundary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getGeneratedBoundary() {
        if (this.generatedBoundary == null) {
            MultipartFormData multipartFormData = this;
            synchronized (multipartFormData) {
                if (this.generatedBoundary == null) {
                    this.generatedBoundary = this.generateBoundary();
                }
            }
        }
        return this.generatedBoundary;
    }

    protected String generateBoundary() {
        byte[] bytes = new byte[8];
        ThreadLocalRandom.current().nextBytes(bytes);
        BigInteger serial = new BigInteger(bytes).abs().shiftLeft(63).add(BigInteger.valueOf(System.currentTimeMillis())).abs();
        return "----FormBoundary" + serial.toString(36);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        String boundary = this.getBoundary();
        boolean first = true;
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.entries()) {
            buffer.setLength(0);
            if (!first) {
                buffer.append("\r\n");
            }
            String name = entry.getKey();
            Object value = entry.getValue();
            buffer.append("--").append(boundary).append("\r\n");
            if (value instanceof MultipartFile) {
                String originalFilename;
                MultipartFile file = (MultipartFile)value;
                String contentType = file.getContentType();
                if (contentType == null) {
                    contentType = "application/octet-stream";
                }
                if ((originalFilename = file.getOriginalFilename()) == null) {
                    originalFilename = "data.bin";
                }
                buffer.append("Content-Disposition: form-data; ").append(this.encodeMimeParameter("name", name)).append("; ").append(this.encodeMimeParameter("filename", originalFilename)).append("\r\n");
                buffer.append("Content-Type: ").append(contentType).append("\r\n\r\n");
                out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                out.write(file.getBytes());
            } else {
                buffer.append("Content-Disposition: form-data; ").append(this.encodeMimeParameter("name", name)).append("\r\n");
                if (this.isTextualAtom(value)) {
                    buffer.append("Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                    out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                    String string = HussarIntegrationConvertUtils.convert(value, String.class);
                    out.write(string.getBytes(StandardCharsets.UTF_8));
                } else if (this.isBinaryAtom(value)) {
                    buffer.append("Content-Type: application/octet-stream\r\n\r\n");
                    out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                    byte[] bytes = HussarIntegrationConvertUtils.convert(value, byte[].class);
                    out.write(bytes);
                } else if (this.isJsonSerializable(value)) {
                    buffer.append("Content-Type: application/json; charset=UTF-8\r\n\r\n");
                    out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
                    byte[] json = HussarIntegrationJsonUtils.toByteArray(value);
                    out.write(json);
                } else {
                    throw new IllegalStateException("unexpected form value: " + value);
                }
            }
            first = false;
        }
        buffer.setLength(0);
        if (!first) {
            buffer.append("\r\n");
        }
        buffer.append("--").append(boundary).append("--").append("\r\n");
        out.write(buffer.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String encodeMimeParameter(String name, String value) {
        if (value.codePoints().allMatch(cp -> cp <= 127 && !Character.isISOControl(cp) && "\"\\".indexOf(cp) < 0)) {
            if (value.codePoints().anyMatch(cp -> Character.isWhitespace(cp) || "()<>@,;:/[]?=".indexOf(cp) >= 0)) {
                return name + "=\"" + value + '\"';
            }
            return name + "=" + value;
        }
        return name + "*=UTF-8''" + UriUtils.encodeScheme((String)value, (Charset)StandardCharsets.UTF_8);
    }

    public String toString() {
        return "MultipartFormData{boundary='" + this.boundary + '\'' + ", data=" + this.data + '}';
    }
}

