/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.formdata;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.jxdinfo.hussar.integration.support.common.formdata.FormData;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractFormData
implements FormData {
    protected ListMultimap<String, Object> data = this.initializeData();

    public AbstractFormData() {
    }

    public AbstractFormData(FormData form) {
        for (Map.Entry<String, Object> entry : form.entries()) {
            this.append(entry.getKey(), entry.getValue());
        }
    }

    protected ListMultimap<String, Object> initializeData() {
        return MultimapBuilder.ListMultimapBuilder.linkedHashKeys().arrayListValues().build();
    }

    protected void appendValue(String name, Object value) {
        if (this.ignoreValue(value)) {
            return;
        }
        if (!this.acceptValue(value)) {
            throw new IllegalArgumentException();
        }
        this.data.put((Object)name, value);
    }

    protected boolean ignoreValue(Object value) {
        return value == null;
    }

    protected abstract boolean acceptValue(Object var1);

    protected boolean isTextualAtom(Object value) {
        return value instanceof CharSequence || value instanceof Number || value instanceof Boolean || value instanceof Clob;
    }

    protected boolean isBinaryAtom(Object value) {
        return value instanceof byte[] || value instanceof Blob;
    }

    protected boolean isJsonSerializable(Object value) {
        return HussarIntegrationJsonUtils.isSerializable(value);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Collection<String> keys() {
        return this.data.keySet();
    }

    @Override
    public Collection<Map.Entry<String, Object>> entries() {
        return this.data.entries();
    }

    @Override
    public boolean has(String name) {
        return this.data.containsKey((Object)name);
    }

    @Override
    public Object get(String name) {
        List values = this.data.get((Object)name);
        if (CollectionUtils.isEmpty((Collection)values)) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public List<Object> getAll(String name) {
        return this.data.get((Object)name);
    }

    @Override
    public void set(String name, Object value) {
        this.data.removeAll((Object)name);
        this.appendValue(name, value);
    }

    @Override
    public <T> void setAll(String name, Collection<T> values) {
        this.data.removeAll((Object)name);
        if (CollectionUtils.isNotEmpty(values)) {
            for (T value : values) {
                this.appendValue(name, value);
            }
        }
    }

    @Override
    public void append(String name, Object value) {
        this.appendValue(name, value);
    }

    @Override
    public <T> void appendAll(String name, Collection<T> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            for (T value : values) {
                this.appendValue(name, value);
            }
        }
    }

    @Override
    public void delete(String name) {
        this.data.removeAll((Object)name);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Map<String, Collection<Object>> toMap() {
        return this.data.asMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFormData that = (AbstractFormData)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }
}

