/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime.recognize;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.helper.DateTimeFormatterHelper;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemporalRecognitionRule<T extends TemporalAccessor> {
    private static final Logger logger = LoggerFactory.getLogger(TemporalRecognitionRule.class);
    private final Class<T> type;
    private final DateTimeFormatter formatter;
    private final BiFunction<CharSequence, DateTimeFormatter, T> parser;
    private final BiPredicate<DateTimeFormatter, String> filter;

    private TemporalRecognitionRule(Class<T> type, DateTimeFormatter formatter, BiFunction<CharSequence, DateTimeFormatter, T> parser, BiPredicate<DateTimeFormatter, String> filter) {
        this.type = type;
        this.parser = parser;
        this.formatter = formatter;
        this.filter = filter;
    }

    public static <T extends TemporalAccessor> TemporalRecognitionRule<T> of(Class<T> type, DateTimeFormatter formatter, BiFunction<CharSequence, DateTimeFormatter, T> parser) {
        return TemporalRecognitionRule.of(type, formatter, parser, null);
    }

    public static <T extends TemporalAccessor> TemporalRecognitionRule<T> of(Class<T> type, DateTimeFormatter formatter, BiFunction<CharSequence, DateTimeFormatter, T> parser, BiPredicate<DateTimeFormatter, String> filter) {
        if (type == null || formatter == null || parser == null) {
            throw new NullPointerException();
        }
        return new TemporalRecognitionRule<T>(type, formatter, parser, filter);
    }

    public static TemporalRecognitionRule<? extends TemporalAccessor> ofPattern(String pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return TemporalRecognitionRule.ofFormatter(formatter);
    }

    public static TemporalRecognitionRule<? extends TemporalAccessor> ofFormatter(DateTimeFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException();
        }
        return DateTimeFormatterHelper.recognitionRuleOf(formatter);
    }

    public T recognize(DateTimeHelper context, String literal) {
        BiPredicate<DateTimeFormatter, String> filter;
        if (literal == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatterHelper.setFallbackLocale(this.formatter, context.getLocale());
        formatter = DateTimeFormatterHelper.setFallbackZone(formatter, context.getZone());
        BiPredicate<DateTimeFormatter, String> biPredicate = filter = this.filter != null ? this.filter : DateTimeFormatterHelper::defaultParseFilter;
        if (!filter.test(formatter, literal)) {
            return null;
        }
        try {
            return (T)((TemporalAccessor)this.parser.apply(literal, formatter));
        }
        catch (DateTimeParseException ex) {
            logger.debug("failed to parse '{}' using formatter {}", new Object[]{literal, formatter, ex});
            return null;
        }
    }

    public Class<T> getType() {
        return this.type;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }

    public BiFunction<CharSequence, DateTimeFormatter, T> getParser() {
        return this.parser;
    }

    public BiPredicate<DateTimeFormatter, String> getFilter() {
        return this.filter;
    }
}

