/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime.helper;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;

public final class LegacyJavaDateHelper {
    private static final BaseCalendar GREGORIAN_CALENDAR = CalendarSystem.getGregorianCalendar();

    private LegacyJavaDateHelper() {
    }

    public static Date toDate(LocalDateTime datetime, ZoneId zone, BaseCalendar calendar) {
        if (datetime == null) {
            throw new NullPointerException();
        }
        zone = zone != null ? zone : ZoneId.systemDefault();
        calendar = calendar != null ? calendar : GREGORIAN_CALENDAR;
        CalendarDate calendarDate = LegacyJavaDateHelper.toCalendarDate(datetime, zone, calendar);
        long timestamp = calendar.getTime(calendarDate);
        return new Date(timestamp);
    }

    public static CalendarDate toCalendarDate(LocalDateTime datetime, ZoneId zone, BaseCalendar calendar) {
        if (datetime == null) {
            throw new NullPointerException();
        }
        zone = zone != null ? zone : ZoneId.systemDefault();
        calendar = calendar != null ? calendar : GREGORIAN_CALENDAR;
        int year = datetime.getYear();
        int month = datetime.getMonth().getValue();
        int day = datetime.getDayOfMonth();
        int hour = datetime.getHour();
        int minute = datetime.getMinute();
        int second = datetime.getSecond();
        int millis = datetime.getNano() / 1000000;
        CalendarDate date = calendar.newCalendarDate(TimeZone.getTimeZone(zone)).setDate(year, month, day).setTimeOfDay(hour, minute, second, millis);
        calendar.normalize(date);
        return date;
    }
}

