/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime.helper;

import com.jxdinfo.hussar.integration.support.common.datetime.recognize.TemporalRecognitionRule;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

public final class DateTimeFormatterHelper {
    private static final Locale DATE_TIME_FORMATTER_DEFAULT_LOCALE = Locale.getDefault(Locale.Category.FORMAT);

    private DateTimeFormatterHelper() {
    }

    public static boolean defaultParseFilter(DateTimeFormatter formatter, String literal) {
        ParsePosition position = new ParsePosition(0);
        TemporalAccessor parsed = formatter.parseUnresolved(literal, position);
        return parsed != null && position.getErrorIndex() < 0 && position.getIndex() == literal.length();
    }

    public static DateTimeFormatter setFallbackLocale(DateTimeFormatter formatter, Locale locale) {
        if (formatter.getLocale() == DATE_TIME_FORMATTER_DEFAULT_LOCALE && locale != null) {
            return formatter.withLocale(locale);
        }
        return formatter;
    }

    public static DateTimeFormatter setFallbackZone(DateTimeFormatter formatter, ZoneId zone) {
        if (formatter.getZone() == null && zone != null) {
            formatter = formatter.withZone(zone);
        }
        return formatter;
    }

    public static DateTimeFormatter setFallbackFields(DateTimeFormatter formatter, Map<TemporalField, Long> values) {
        if (MapUtils.isEmpty(values)) {
            return formatter;
        }
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().append(formatter);
        for (Map.Entry<TemporalField, Long> entry : values.entrySet()) {
            TemporalField field = entry.getKey();
            Long value = entry.getValue();
            if (field == null || value == null) continue;
            builder.parseDefaulting(field, value);
        }
        return builder.toFormatter(formatter.getLocale()).withZone(formatter.getZone()).withChronology(formatter.getChronology()).withLocale(formatter.getLocale()).withDecimalStyle(formatter.getDecimalStyle()).withResolverStyle(formatter.getResolverStyle()).withResolverFields(formatter.getResolverFields());
    }

    public static TemporalRecognitionRule<? extends TemporalAccessor> recognitionRuleOf(DateTimeFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException();
        }
        Class<? extends TemporalAccessor> type = DateTimeFormatterHelper.guessTargetingParsedType(formatter);
        if (type == null) {
            return TemporalRecognitionRule.of(TemporalAccessor.class, formatter, (text, fmt) -> fmt.parse((CharSequence)text));
        }
        if (type == LocalDateTime.class) {
            return TemporalRecognitionRule.of(LocalDateTime.class, formatter, LocalDateTime::parse);
        }
        if (type == Instant.class) {
            return TemporalRecognitionRule.of(Instant.class, formatter, (text, fmt) -> fmt.parse((CharSequence)text, Instant::from));
        }
        if (type == ZonedDateTime.class) {
            return TemporalRecognitionRule.of(ZonedDateTime.class, formatter, ZonedDateTime::parse);
        }
        if (type == OffsetDateTime.class) {
            return TemporalRecognitionRule.of(OffsetDateTime.class, formatter, OffsetDateTime::parse);
        }
        if (type == LocalDate.class) {
            return TemporalRecognitionRule.of(LocalDate.class, formatter, LocalDate::parse);
        }
        if (type == LocalTime.class) {
            return TemporalRecognitionRule.of(LocalTime.class, formatter, LocalTime::parse);
        }
        if (type == OffsetTime.class) {
            return TemporalRecognitionRule.of(OffsetTime.class, formatter, OffsetTime::parse);
        }
        throw new IllegalArgumentException("unhandled temporal accessor type: " + type);
    }

    public static boolean isProbablyDateTimePattern(String pattern) {
        Class<? extends TemporalAccessor> type = DateTimeFormatterHelper.guessTargetingParsedType(pattern);
        return type == LocalDateTime.class || type == ZonedDateTime.class || type == OffsetDateTime.class || type == Instant.class;
    }

    public static boolean isProbablyDatePattern(String pattern) {
        Class<? extends TemporalAccessor> type = DateTimeFormatterHelper.guessTargetingParsedType(pattern);
        return type == LocalDate.class;
    }

    public static boolean isProbablyTimePattern(String pattern) {
        Class<? extends TemporalAccessor> type = DateTimeFormatterHelper.guessTargetingParsedType(pattern);
        return type == LocalTime.class || type == OffsetTime.class;
    }

    private static Class<? extends TemporalAccessor> guessTargetingParsedType(String pattern) {
        DateTimeFormatter formatter;
        if (pattern.isEmpty()) {
            return null;
        }
        try {
            formatter = DateTimeFormatter.ofPattern(pattern);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
        return DateTimeFormatterHelper.guessTargetingParsedType(formatter);
    }

    public static Class<? extends TemporalAccessor> guessTargetingParsedType(DateTimeFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException();
        }
        FieldProbingTemporalAccessor probe = new FieldProbingTemporalAccessor();
        try {
            formatter.format(probe);
        }
        catch (DateTimeException ignore) {
            return null;
        }
        String internal = formatter.toString();
        boolean instant = probe.isProbablyInstant();
        boolean date = probe.isProbablyDate();
        boolean time = probe.isProbablyTime();
        boolean zoneId = internal.contains("ZoneId(") || internal.contains("ZoneRegionId(") || internal.contains("ZoneOrOffsetId(") || internal.contains("ZoneText(");
        boolean zoneOffset = probe.isProbablyHasOffset();
        if (date && time) {
            if (zoneId) {
                return ZonedDateTime.class;
            }
            if (zoneOffset) {
                return OffsetDateTime.class;
            }
            return LocalDateTime.class;
        }
        if (date) {
            if (zoneId || zoneOffset) {
                return null;
            }
            return LocalDate.class;
        }
        if (time) {
            if (zoneId) {
                return null;
            }
            if (zoneOffset) {
                return OffsetTime.class;
            }
            return LocalTime.class;
        }
        if (instant) {
            return Instant.class;
        }
        return null;
    }

    private static final class FieldProbingTemporalAccessor
    implements TemporalAccessor {
        private final Set<TemporalField> fields = new LinkedHashSet<TemporalField>();

        private FieldProbingTemporalAccessor() {
        }

        @Override
        public boolean isSupported(TemporalField field) {
            return true;
        }

        @Override
        public long getLong(TemporalField field) {
            this.fields.add(field);
            long min = field.range().getMinimum();
            long max = field.range().getMaximum();
            if (min <= 0L && max >= 0L) {
                return 0L;
            }
            return min;
        }

        @Override
        public <R> R query(TemporalQuery<R> query) {
            if (query == TemporalQueries.zone()) {
                return (R)ZoneOffset.UTC;
            }
            if (query == TemporalQueries.zoneId()) {
                return (R)ZoneId.of("UTC");
            }
            if (query == TemporalQueries.offset()) {
                return (R)ZoneOffset.UTC;
            }
            if (query == TemporalQueries.chronology()) {
                return (R)IsoChronology.INSTANCE;
            }
            if (query == TemporalQueries.precision()) {
                return (R)ChronoUnit.NANOS;
            }
            if (query == TemporalQueries.localDate()) {
                return (R)LocalDate.of(0, 1, 1);
            }
            if (query == TemporalQueries.localTime()) {
                return (R)LocalTime.of(0, 0, 0);
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isProbablyDate() {
            if (this.hasField(ChronoField.EPOCH_DAY)) {
                return true;
            }
            if (this.hasField(ChronoField.YEAR) || this.hasField(ChronoField.YEAR_OF_ERA)) {
                if (this.hasField(ChronoField.DAY_OF_YEAR)) {
                    return true;
                }
                if (this.hasField(ChronoField.MONTH_OF_YEAR)) {
                    if (this.hasField(ChronoField.DAY_OF_MONTH)) {
                        return true;
                    }
                    if (!this.hasField(ChronoField.ALIGNED_WEEK_OF_MONTH)) return false;
                    if (!this.hasField(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH)) return false;
                    return true;
                }
                if (!this.hasField(ChronoField.ALIGNED_WEEK_OF_YEAR)) return false;
                if (!this.hasField(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR)) return false;
                return true;
            }
            if (!this.hasField(ChronoField.PROLEPTIC_MONTH)) return false;
            if (!this.hasField(ChronoField.DAY_OF_MONTH)) return false;
            return true;
        }

        public boolean isProbablyTime() {
            if (this.hasField(ChronoField.HOUR_OF_DAY) || this.hasField(ChronoField.CLOCK_HOUR_OF_DAY)) {
                if (this.hasField(ChronoField.MINUTE_OF_HOUR)) {
                    return true;
                }
            } else if (this.hasField(ChronoField.AMPM_OF_DAY)) {
                if ((this.hasField(ChronoField.HOUR_OF_AMPM) || this.hasField(ChronoField.CLOCK_HOUR_OF_AMPM)) && this.hasField(ChronoField.MINUTE_OF_HOUR)) {
                    return true;
                }
            } else {
                if (this.hasField(ChronoField.MINUTE_OF_DAY)) {
                    return true;
                }
                if (this.hasField(ChronoField.SECOND_OF_DAY)) {
                    return true;
                }
                if (this.hasField(ChronoField.MILLI_OF_DAY)) {
                    return true;
                }
                if (this.hasField(ChronoField.MICRO_OF_DAY)) {
                    return true;
                }
                if (this.hasField(ChronoField.NANO_OF_DAY)) {
                    return true;
                }
            }
            return false;
        }

        public boolean isProbablyHasOffset() {
            return this.hasField(ChronoField.OFFSET_SECONDS);
        }

        public boolean isProbablyInstant() {
            return this.hasField(ChronoField.INSTANT_SECONDS) && !this.hasField(ChronoField.OFFSET_SECONDS);
        }

        public boolean hasField(TemporalField field) {
            return this.fields.contains(field);
        }

        public Set<TemporalField> getFields() {
            return this.fields;
        }
    }
}

