/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime.formating;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.helper.DateTimeFormatterHelper;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemporalFormatingRule {
    private static final Logger logger = LoggerFactory.getLogger(TemporalFormatingRule.class);
    private final Class<? extends TemporalAccessor> type;
    private final DateTimeFormatter formatter;

    private TemporalFormatingRule(Class<? extends TemporalAccessor> type, DateTimeFormatter formatter) {
        this.type = type;
        this.formatter = formatter;
    }

    public static TemporalFormatingRule of(Class<? extends TemporalAccessor> type, DateTimeFormatter formatter) {
        if (type == null || formatter == null) {
            throw new NullPointerException();
        }
        return new TemporalFormatingRule(type, formatter);
    }

    public String format(DateTimeHelper context, TemporalAccessor temporal) {
        if (temporal == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatterHelper.setFallbackLocale(this.formatter, context.getLocale());
        try {
            return formatter.format(temporal);
        }
        catch (DateTimeParseException ex) {
            logger.debug("failed to format '{}' using formatter {}", new Object[]{temporal, formatter, ex});
            return null;
        }
    }

    public Class<? extends TemporalAccessor> getType() {
        return this.type;
    }

    public DateTimeFormatter getFormatter() {
        return this.formatter;
    }
}

