/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime.conversion;

import com.jxdinfo.hussar.integration.support.common.constants.DateTimeConstants;
import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.TemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.helper.LegacyJavaDateHelper;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownTemporalConversionRule
implements TemporalConversionRule<TemporalAccessor> {
    private static final Logger logger = LoggerFactory.getLogger(UnknownTemporalConversionRule.class);

    @Override
    public Class<? extends TemporalAccessor> getType() {
        return DateTimeConstants.UNKNOWN_TEMPORAL_ACCESSOR_PLACEHOLDER;
    }

    @Override
    public Instant toInstant(DateTimeHelper context, TemporalAccessor temporal) {
        if (!temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
            return null;
        }
        try {
            long seconds = this.getLongField(context, temporal, ChronoField.INSTANT_SECONDS);
            long nanos = this.getLongField(context, temporal, ChronoField.NANO_OF_SECOND);
            return Instant.ofEpochSecond(seconds, nanos);
        }
        catch (DateTimeException ex) {
            logger.debug("failed to convert unknown TemporalAccessor ({}, typed {}) to Instant", new Object[]{temporal, temporal.getClass(), ex});
            return null;
        }
    }

    @Override
    public LocalDateTime toLocalDateTime(DateTimeHelper context, TemporalAccessor temporal) {
        if (!(temporal.isSupported(ChronoField.YEAR) || temporal.isSupported(ChronoField.MONTH_OF_YEAR) || temporal.isSupported(ChronoField.DAY_OF_MONTH) || temporal.isSupported(ChronoField.HOUR_OF_DAY) || temporal.isSupported(ChronoField.MINUTE_OF_HOUR) || temporal.isSupported(ChronoField.SECOND_OF_MINUTE))) {
            return null;
        }
        try {
            int year = this.getIntField(context, temporal, ChronoField.YEAR);
            int month = this.getIntField(context, temporal, ChronoField.MONTH_OF_YEAR);
            int day = this.getIntField(context, temporal, ChronoField.DAY_OF_MONTH);
            int hours = this.getIntField(context, temporal, ChronoField.HOUR_OF_DAY);
            int minutes = this.getIntField(context, temporal, ChronoField.MINUTE_OF_HOUR);
            int seconds = this.getIntField(context, temporal, ChronoField.SECOND_OF_MINUTE);
            int nanos = this.getIntField(context, temporal, ChronoField.NANO_OF_SECOND);
            return LocalDateTime.of(year, month, day, hours, minutes, seconds, nanos);
        }
        catch (DateTimeException ex) {
            logger.debug("failed to convert unknown TemporalAccessor ({}, typed {}) to LocalDateTime", new Object[]{temporal, temporal.getClass(), ex});
            return null;
        }
    }

    @Override
    public OffsetDateTime toOffsetDateTime(DateTimeHelper context, TemporalAccessor temporal) {
        if (!(temporal.isSupported(ChronoField.YEAR) || temporal.isSupported(ChronoField.MONTH_OF_YEAR) || temporal.isSupported(ChronoField.DAY_OF_MONTH) || temporal.isSupported(ChronoField.HOUR_OF_DAY) || temporal.isSupported(ChronoField.MINUTE_OF_HOUR) || temporal.isSupported(ChronoField.SECOND_OF_MINUTE) || temporal.isSupported(ChronoField.OFFSET_SECONDS))) {
            return null;
        }
        try {
            int year = this.getIntField(context, temporal, ChronoField.YEAR);
            int month = this.getIntField(context, temporal, ChronoField.MONTH_OF_YEAR);
            int day = this.getIntField(context, temporal, ChronoField.DAY_OF_MONTH);
            int hours = this.getIntField(context, temporal, ChronoField.HOUR_OF_DAY);
            int minutes = this.getIntField(context, temporal, ChronoField.MINUTE_OF_HOUR);
            int seconds = this.getIntField(context, temporal, ChronoField.SECOND_OF_MINUTE);
            int nanos = this.getIntField(context, temporal, ChronoField.NANO_OF_SECOND);
            int offsetSeconds = this.getIntField(context, temporal, ChronoField.OFFSET_SECONDS);
            ZoneOffset offset = ZoneOffset.ofTotalSeconds(offsetSeconds);
            return OffsetDateTime.of(year, month, day, hours, minutes, seconds, nanos, offset);
        }
        catch (DateTimeException ex) {
            logger.debug("failed to convert unknown TemporalAccessor ({}, typed {}) to OffsetDateTime", new Object[]{temporal, temporal.getClass(), ex});
            return null;
        }
    }

    @Override
    public ZonedDateTime toZonedDateTime(DateTimeHelper context, TemporalAccessor temporal) {
        OffsetDateTime offsetDateTime = this.toOffsetDateTime(context, temporal);
        if (offsetDateTime == null) {
            return null;
        }
        return offsetDateTime.toZonedDateTime();
    }

    @Override
    public LocalDate toLocalDate(DateTimeHelper context, TemporalAccessor temporal) {
        if (!(temporal.isSupported(ChronoField.YEAR) || temporal.isSupported(ChronoField.MONTH_OF_YEAR) || temporal.isSupported(ChronoField.DAY_OF_MONTH))) {
            return null;
        }
        try {
            int year = this.getIntField(context, temporal, ChronoField.YEAR);
            int month = this.getIntField(context, temporal, ChronoField.MONTH_OF_YEAR);
            int day = this.getIntField(context, temporal, ChronoField.DAY_OF_MONTH);
            return LocalDate.of(year, month, day);
        }
        catch (DateTimeException ex) {
            logger.debug("failed to convert unknown TemporalAccessor ({}, typed {}) to LocalDate", new Object[]{temporal, temporal.getClass(), ex});
            return null;
        }
    }

    @Override
    public LocalTime toLocalTime(DateTimeHelper context, TemporalAccessor temporal) {
        if (!(temporal.isSupported(ChronoField.HOUR_OF_DAY) || temporal.isSupported(ChronoField.MINUTE_OF_HOUR) || temporal.isSupported(ChronoField.SECOND_OF_MINUTE))) {
            return null;
        }
        try {
            int hours = this.getIntField(context, temporal, ChronoField.HOUR_OF_DAY);
            int minutes = this.getIntField(context, temporal, ChronoField.MINUTE_OF_HOUR);
            int seconds = this.getIntField(context, temporal, ChronoField.SECOND_OF_MINUTE);
            int nanos = this.getIntField(context, temporal, ChronoField.NANO_OF_SECOND);
            return LocalTime.of(hours, minutes, seconds, nanos);
        }
        catch (DateTimeException ex) {
            logger.debug("failed to convert unknown TemporalAccessor ({}, typed {}) to LocalTime", new Object[]{temporal, temporal.getClass(), ex});
            return null;
        }
    }

    @Override
    public OffsetTime toOffsetTime(DateTimeHelper context, TemporalAccessor temporal) {
        if (!(temporal.isSupported(ChronoField.HOUR_OF_DAY) || temporal.isSupported(ChronoField.MINUTE_OF_HOUR) || temporal.isSupported(ChronoField.SECOND_OF_MINUTE) || temporal.isSupported(ChronoField.OFFSET_SECONDS))) {
            return null;
        }
        try {
            int hours = this.getIntField(context, temporal, ChronoField.HOUR_OF_DAY);
            int minutes = this.getIntField(context, temporal, ChronoField.MINUTE_OF_HOUR);
            int seconds = this.getIntField(context, temporal, ChronoField.SECOND_OF_MINUTE);
            int nanos = this.getIntField(context, temporal, ChronoField.NANO_OF_SECOND);
            int offsetSeconds = this.getIntField(context, temporal, ChronoField.OFFSET_SECONDS);
            ZoneOffset offset = ZoneOffset.ofTotalSeconds(offsetSeconds);
            return OffsetTime.of(hours, minutes, seconds, nanos, offset);
        }
        catch (DateTimeException ex) {
            logger.debug("failed to convert unknown TemporalAccessor ({}, typed {}) to OffsetTime", new Object[]{temporal, temporal.getClass(), ex});
            return null;
        }
    }

    @Override
    public Date toDate(DateTimeHelper context, TemporalAccessor temporal) {
        if (temporal.isSupported(ChronoField.INSTANT_SECONDS)) {
            Instant instant = this.toInstant(context, temporal);
            if (instant == null) {
                return null;
            }
            return Date.from(instant);
        }
        LocalDateTime datetime = this.toLocalDateTime(context, temporal);
        if (datetime == null) {
            return null;
        }
        return LegacyJavaDateHelper.toDate(datetime, context.getZone(), null);
    }

    private int getIntField(DateTimeHelper context, TemporalAccessor temporal, TemporalField field) {
        return Math.toIntExact(this.getLongField(context, temporal, field));
    }

    private long getLongField(DateTimeHelper context, TemporalAccessor temporal, TemporalField field) {
        if (temporal.isSupported(field)) {
            return temporal.range(field).isIntValue() ? (long)temporal.get(field) : temporal.getLong(field);
        }
        LocalDate fallback = context.getFallbackDate();
        if (fallback.isSupported(field)) {
            return fallback.range(field).isIntValue() ? (long)fallback.get(field) : fallback.getLong(field);
        }
        long min = field.range().getMinimum();
        long max = field.range().getMaximum();
        if (min <= 0L && max >= 0L) {
            return 0L;
        }
        return min;
    }
}

