/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.integration.support.common.datetime.conversion;

import com.jxdinfo.hussar.integration.support.common.datetime.DateTimeHelper;
import com.jxdinfo.hussar.integration.support.common.datetime.conversion.AbstractTemporalConversionRule;
import com.jxdinfo.hussar.integration.support.common.datetime.helper.LegacyJavaDateHelper;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;

public final class LocalTimeTemporalConversionRule
extends AbstractTemporalConversionRule<LocalTime> {
    @Override
    public Class<LocalTime> getType() {
        return LocalTime.class;
    }

    @Override
    public LocalDateTime toLocalDateTime(DateTimeHelper context, LocalTime temporal) {
        return temporal.atDate(context.getFallbackDate());
    }

    @Override
    public ZonedDateTime toZonedDateTime(DateTimeHelper context, LocalTime temporal) {
        return this.toLocalDateTime(context, temporal).atZone(context.getZone());
    }

    @Override
    public LocalTime toLocalTime(DateTimeHelper context, LocalTime temporal) {
        return temporal;
    }

    @Override
    public Date toDate(DateTimeHelper context, LocalTime temporal) {
        LocalDateTime datetime = this.toLocalDateTime(context, temporal);
        return LegacyJavaDateHelper.toDate(datetime, context.getZone(), null);
    }
}

